/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MethodDocImpl;
import com.sun.tools.javadoc.SerialFieldTagImpl;

class SerializedForm {
    ListBuffer<MethodDoc> methods = new ListBuffer();
    private final ListBuffer<FieldDocImpl> fields = new ListBuffer();
    private boolean definesSerializableFields = false;
    private static final String SERIALIZABLE_FIELDS = "serialPersistentFields";
    private static final String READOBJECT = "readObject";
    private static final String WRITEOBJECT = "writeObject";
    private static final String READRESOLVE = "readResolve";
    private static final String WRITEREPLACE = "writeReplace";
    private static final String READOBJECTNODATA = "readObjectNoData";

    SerializedForm(DocEnv docEnv, Symbol.ClassSymbol classSymbol, ClassDocImpl classDocImpl) {
        if (classDocImpl.isExternalizable()) {
            String[] stringArray = new String[]{"java.io.ObjectInput"};
            String[] stringArray2 = new String[]{"java.io.ObjectOutput"};
            MethodDocImpl methodDocImpl = classDocImpl.findMethod("readExternal", stringArray);
            if (methodDocImpl != null) {
                this.methods.append(methodDocImpl);
            }
            if ((methodDocImpl = classDocImpl.findMethod("writeExternal", stringArray2)) != null) {
                this.methods.append(methodDocImpl);
                Tag[] tagArray = methodDocImpl.tags("serialData");
            }
        } else if (classDocImpl.isSerializable()) {
            Symbol.VarSymbol varSymbol = this.getDefinedSerializableFields(classSymbol);
            if (varSymbol != null) {
                this.definesSerializableFields = true;
                FieldDocImpl fieldDocImpl = docEnv.getFieldDoc(varSymbol);
                this.fields.append(fieldDocImpl);
                this.mapSerialFieldTagImplsToFieldDocImpls(fieldDocImpl, docEnv, classSymbol);
            } else {
                this.computeDefaultSerializableFields(docEnv, classSymbol, classDocImpl);
            }
            this.addMethodIfExist(docEnv, classSymbol, READOBJECT);
            this.addMethodIfExist(docEnv, classSymbol, WRITEOBJECT);
            this.addMethodIfExist(docEnv, classSymbol, READRESOLVE);
            this.addMethodIfExist(docEnv, classSymbol, WRITEREPLACE);
            this.addMethodIfExist(docEnv, classSymbol, READOBJECTNODATA);
        }
    }

    private Symbol.VarSymbol getDefinedSerializableFields(Symbol.ClassSymbol classSymbol) {
        Names names = classSymbol.name.table.names;
        Scope.Entry entry = classSymbol.members().lookup(names.fromString(SERIALIZABLE_FIELDS));
        while (entry.scope != null) {
            Symbol.VarSymbol varSymbol;
            if (entry.sym.kind == 4 && ((varSymbol = (Symbol.VarSymbol)entry.sym).flags() & 8L) != 0L && (varSymbol.flags() & 2L) != 0L) {
                return varSymbol;
            }
            entry = entry.next();
        }
        return null;
    }

    private void computeDefaultSerializableFields(DocEnv docEnv, Symbol.ClassSymbol classSymbol, ClassDocImpl classDocImpl) {
        Scope.Entry entry = classSymbol.members().elems;
        while (entry != null) {
            Symbol.VarSymbol varSymbol;
            if (entry.sym != null && entry.sym.kind == 4 && ((varSymbol = (Symbol.VarSymbol)entry.sym).flags() & 8L) == 0L && (varSymbol.flags() & 0x80L) == 0L) {
                FieldDocImpl fieldDocImpl = docEnv.getFieldDoc(varSymbol);
                this.fields.prepend(fieldDocImpl);
            }
            entry = entry.sibling;
        }
    }

    private void addMethodIfExist(DocEnv docEnv, Symbol.ClassSymbol classSymbol, String string) {
        Names names = classSymbol.name.table.names;
        Scope.Entry entry = classSymbol.members().lookup(names.fromString(string));
        while (entry.scope != null) {
            Symbol.MethodSymbol methodSymbol;
            if (entry.sym.kind == 16 && ((methodSymbol = (Symbol.MethodSymbol)entry.sym).flags() & 8L) == 0L) {
                this.methods.append(docEnv.getMethodDoc(methodSymbol));
            }
            entry = entry.next();
        }
    }

    private void mapSerialFieldTagImplsToFieldDocImpls(FieldDocImpl fieldDocImpl, DocEnv docEnv, Symbol.ClassSymbol classSymbol) {
        Names names = classSymbol.name.table.names;
        SerialFieldTag[] serialFieldTagArray = fieldDocImpl.serialFieldTags();
        block0: for (int i = 0; i < serialFieldTagArray.length; ++i) {
            Name name = names.fromString(serialFieldTagArray[i].fieldName());
            Scope.Entry entry = classSymbol.members().lookup(name);
            while (entry.scope != null) {
                if (entry.sym.kind == 4) {
                    Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)entry.sym;
                    FieldDocImpl fieldDocImpl2 = docEnv.getFieldDoc(varSymbol);
                    ((SerialFieldTagImpl)serialFieldTagArray[i]).mapToFieldDocImpl(fieldDocImpl2);
                    continue block0;
                }
                entry = entry.next();
            }
        }
    }

    FieldDoc[] fields() {
        return this.fields.toArray(new FieldDocImpl[this.fields.length()]);
    }

    MethodDoc[] methods() {
        return this.methods.toArray(new MethodDoc[this.methods.length()]);
    }

    boolean definesSerializableFields() {
        return this.definesSerializableFields;
    }
}

