/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.OpCodes;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;

class CodeWriter
extends BasicWriter {
    private AttributeWriter attrWriter;
    private ClassWriter classWriter;
    private ConstantWriter constantWriter;

    static CodeWriter instance(Context context) {
        CodeWriter codeWriter = context.get(CodeWriter.class);
        if (codeWriter == null) {
            codeWriter = new CodeWriter(context);
        }
        return codeWriter;
    }

    protected CodeWriter(Context context) {
        super(context);
        context.put(CodeWriter.class, this);
        this.attrWriter = AttributeWriter.instance(context);
        this.classWriter = ClassWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
    }

    void write(Code_attribute code_attribute, ConstantPool constantPool) {
        this.println("  Code:");
        this.writeVerboseHeader(code_attribute, constantPool);
        this.writeInstrs(code_attribute);
        this.writeExceptionTable(code_attribute);
        this.attrWriter.write((Object)code_attribute, code_attribute.attributes, constantPool);
    }

    public void writeVerboseHeader(Code_attribute code_attribute, ConstantPool constantPool) {
        String string;
        Method method = this.classWriter.getMethod();
        try {
            int n = method.descriptor.getParameterCount(constantPool);
            if (!method.access_flags.is(8)) {
                ++n;
            }
            string = Integer.toString(n);
        }
        catch (ConstantPoolException constantPoolException) {
            string = this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            string = this.report(descriptorException);
        }
        this.println("   Stack=" + code_attribute.max_stack + ", Locals=" + code_attribute.max_locals + ", Args_size=" + string);
    }

    public void writeInstrs(Code_attribute code_attribute) {
        try {
            for (int i = 0; i < code_attribute.code_length; i += this.writeInstr(code_attribute, i)) {
                this.print("   " + i + ":\t");
                this.println();
            }
        }
        catch (Code_attribute.InvalidIndex invalidIndex) {
            this.println(this.report(invalidIndex));
        }
    }

    public int writeInstr(Code_attribute code_attribute, int n) throws Code_attribute.InvalidIndex {
        String string = "";
        int n2 = code_attribute.getUnsignedByte(n);
        switch (n2) {
            case 254: 
            case 255: {
                int n3 = code_attribute.getUnsignedByte(n + 1);
                String string2 = OpCodes.opcName((n2 << 8) + n3);
                if (string2 == null) {
                    string2 = OpCodes.opcName(n2) + " " + n3;
                }
                this.print(string2);
                return 2;
            }
            case 196: {
                int n4 = code_attribute.getUnsignedByte(n + 1);
                String string3 = OpCodes.opcName((n2 << 8) + n4);
                if (string3 == null) {
                    this.print("bytecode " + n2);
                    return 1;
                }
                this.print(string3 + " " + code_attribute.getUnsignedShort(n + 2));
                if (n4 == 132) {
                    this.print(", " + code_attribute.getShort(n + 4));
                    return 6;
                }
                return 4;
            }
        }
        String string4 = OpCodes.opcName(n2);
        if (string4 == null) {
            this.print("bytecode " + n2);
            return 1;
        }
        if (n2 > 201) {
            this.print("bytecode " + n2);
            return 1;
        }
        this.print(OpCodes.opcName(n2));
        switch (n2) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                this.print("\t" + code_attribute.getUnsignedByte(n + 1));
                return 2;
            }
            case 132: {
                this.print("\t" + code_attribute.getUnsignedByte(n + 1) + ", " + code_attribute.getByte(n + 2));
                return 3;
            }
            case 170: {
                int n5 = CodeWriter.align(n + 1);
                int n6 = code_attribute.getInt(n5);
                int n7 = code_attribute.getInt(n5 + 4);
                int n8 = code_attribute.getInt(n5 + 8);
                int n9 = n8 - n7;
                this.print("{ //" + n7 + " to " + n8);
                for (int i = 0; i <= n9; ++i) {
                    this.print("\n\t\t" + (i + n7) + ": " + string + (n + code_attribute.getInt(n5 + 12 + 4 * i)) + ";");
                }
                this.print("\n\t\tdefault: " + string + (n6 + n) + " }");
                return n5 - n + 16 + n9 * 4;
            }
            case 171: {
                int n10 = CodeWriter.align(n + 1);
                int n11 = code_attribute.getInt(n10);
                int n12 = code_attribute.getInt(n10 + 4);
                this.print("{ //" + n12);
                for (int i = 1; i <= n12; ++i) {
                    this.print("\n\t\t" + code_attribute.getInt(n10 + i * 8) + ": " + string + (n + code_attribute.getInt(n10 + 4 + i * 8)) + ";");
                }
                this.print("\n\t\tdefault: " + string + (n11 + n) + " }");
                return n10 - n + (n12 + 1) * 8;
            }
            case 188: {
                int n13 = code_attribute.getUnsignedByte(n + 1);
                switch (n13) {
                    case 4: {
                        this.print(" boolean");
                        break;
                    }
                    case 8: {
                        this.print(" byte");
                        break;
                    }
                    case 5: {
                        this.print(" char");
                        break;
                    }
                    case 9: {
                        this.print(" short");
                        break;
                    }
                    case 10: {
                        this.print(" int");
                        break;
                    }
                    case 11: {
                        this.print(" long");
                        break;
                    }
                    case 6: {
                        this.print(" float");
                        break;
                    }
                    case 7: {
                        this.print(" double");
                        break;
                    }
                    case 2: {
                        this.print(" class");
                        break;
                    }
                    default: {
                        this.print(" BOGUS TYPE:" + n13);
                    }
                }
                return 2;
            }
            case 189: {
                int n14 = code_attribute.getUnsignedShort(n + 1);
                this.print("\t#" + n14 + "; //");
                this.printConstant(n14);
                return 3;
            }
            case 17: {
                this.print("\t" + code_attribute.getShort(n + 1));
                return 3;
            }
            case 16: {
                this.print("\t" + code_attribute.getByte(n + 1));
                return 2;
            }
            case 18: {
                int n15 = code_attribute.getUnsignedByte(n + 1);
                this.print("\t#" + n15 + "; //");
                this.printConstant(n15);
                return 2;
            }
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 192: 
            case 193: {
                int n16 = code_attribute.getUnsignedShort(n + 1);
                this.print("\t#" + n16 + "; //");
                this.printConstant(n16);
                return 3;
            }
            case 185: {
                int n17 = code_attribute.getUnsignedShort(n + 1);
                int n18 = code_attribute.getUnsignedByte(n + 3);
                this.print("\t#" + n17 + ",  " + n18 + "; //");
                this.printConstant(n17);
                return 5;
            }
            case 197: {
                int n19 = code_attribute.getUnsignedShort(n + 1);
                int n20 = code_attribute.getUnsignedByte(n + 3);
                this.print("\t#" + n19 + ",  " + n20 + "; //");
                this.printConstant(n19);
                return 4;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                this.print("\t" + string + (n + code_attribute.getShort(n + 1)));
                return 3;
            }
            case 200: 
            case 201: {
                this.print("\t" + string + (n + code_attribute.getInt(n + 1)));
                return 5;
            }
        }
        return 1;
    }

    public void writeExceptionTable(Code_attribute code_attribute) {
        if (code_attribute.exception_table_langth > 0) {
            this.println("  Exception table:");
            this.println("   from   to  target type");
            for (int i = 0; i < code_attribute.exception_table.length; ++i) {
                Code_attribute.Exception_data exception_data = code_attribute.exception_table[i];
                this.printFixedWidthInt(exception_data.start_pc, 6);
                this.printFixedWidthInt(exception_data.end_pc, 6);
                this.printFixedWidthInt(exception_data.handler_pc, 6);
                this.print("   ");
                int n = exception_data.catch_type;
                if (n == 0) {
                    this.println("any");
                    continue;
                }
                this.print("Class ");
                this.println(this.constantWriter.stringValue(n));
                this.println("");
            }
        }
    }

    private void printConstant(int n) {
        this.constantWriter.write(n);
    }

    private void printFixedWidthInt(int n, int n2) {
        String string = String.valueOf(n);
        for (int i = string.length(); i < n2; ++i) {
            this.print(" ");
        }
        this.print(string);
    }

    private static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }
}

