/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.nc;

import com.sun.xml.internal.rngom.nc.NameClass;
import com.sun.xml.internal.rngom.nc.NameClassVisitor;
import com.sun.xml.internal.rngom.nc.SimpleNameClass;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverlapDetector
implements NameClassVisitor<Void> {
    private NameClass nc1;
    private NameClass nc2;
    private boolean overlaps = false;
    static final String IMPOSSIBLE = "\u0000";

    private OverlapDetector(NameClass nameClass, NameClass nameClass2) {
        this.nc1 = nameClass;
        this.nc2 = nameClass2;
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    private void probe(QName qName) {
        if (this.nc1.contains(qName) && this.nc2.contains(qName)) {
            this.overlaps = true;
        }
    }

    @Override
    public Void visitChoice(NameClass nameClass, NameClass nameClass2) {
        nameClass.accept(this);
        nameClass2.accept(this);
        return null;
    }

    @Override
    public Void visitNsName(String string) {
        this.probe(new QName(string, IMPOSSIBLE));
        return null;
    }

    @Override
    public Void visitNsNameExcept(String string, NameClass nameClass) {
        this.probe(new QName(string, IMPOSSIBLE));
        nameClass.accept(this);
        return null;
    }

    @Override
    public Void visitAnyName() {
        this.probe(new QName(IMPOSSIBLE, IMPOSSIBLE));
        return null;
    }

    @Override
    public Void visitAnyNameExcept(NameClass nameClass) {
        this.probe(new QName(IMPOSSIBLE, IMPOSSIBLE));
        nameClass.accept(this);
        return null;
    }

    @Override
    public Void visitName(QName qName) {
        this.probe(qName);
        return null;
    }

    @Override
    public Void visitNull() {
        return null;
    }

    static boolean overlap(NameClass nameClass, NameClass nameClass2) {
        if (nameClass2 instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass2;
            return nameClass.contains(simpleNameClass.name);
        }
        if (nameClass instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
            return nameClass2.contains(simpleNameClass.name);
        }
        return new OverlapDetector((NameClass)nameClass, (NameClass)nameClass2).overlaps;
    }
}

