/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.parser;

import com.sun.xml.internal.xsom.XSAttGroupDecl;
import com.sun.xml.internal.xsom.XSAttributeDecl;
import com.sun.xml.internal.xsom.XSComplexType;
import com.sun.xml.internal.xsom.XSDeclaration;
import com.sun.xml.internal.xsom.XSElementDecl;
import com.sun.xml.internal.xsom.XSIdentityConstraint;
import com.sun.xml.internal.xsom.XSModelGroupDecl;
import com.sun.xml.internal.xsom.XSSchemaSet;
import com.sun.xml.internal.xsom.XSSimpleType;
import com.sun.xml.internal.xsom.XSTerm;
import com.sun.xml.internal.xsom.XSType;
import com.sun.xml.internal.xsom.impl.Ref;
import com.sun.xml.internal.xsom.impl.SchemaImpl;
import com.sun.xml.internal.xsom.impl.UName;
import com.sun.xml.internal.xsom.impl.parser.Messages;
import com.sun.xml.internal.xsom.impl.parser.Patch;
import com.sun.xml.internal.xsom.impl.parser.PatcherManager;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class DelayedRef
implements Patch {
    protected final XSSchemaSet schema;
    private PatcherManager manager;
    private UName name;
    private Locator source;
    private Object ref = null;

    DelayedRef(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
        this.schema = schemaImpl.getParent();
        this.manager = patcherManager;
        this.name = uName;
        this.source = locator;
        if (this.name == null) {
            throw new InternalError();
        }
        this.manager.addPatcher(this);
    }

    public void run() throws SAXException {
        if (this.ref == null) {
            this.resolve();
        }
        this.manager = null;
        this.name = null;
        this.source = null;
    }

    protected abstract Object resolveReference(UName var1);

    protected abstract String getErrorProperty();

    protected final Object _get() {
        if (this.ref == null) {
            throw new InternalError("unresolved reference");
        }
        return this.ref;
    }

    private void resolve() throws SAXException {
        this.ref = this.resolveReference(this.name);
        if (this.ref == null) {
            this.manager.reportError(Messages.format(this.getErrorProperty(), this.name.getQualifiedName()), this.source);
        }
    }

    public void redefine(XSDeclaration xSDeclaration) {
        if (!xSDeclaration.getTargetNamespace().equals(this.name.getNamespaceURI()) || !xSDeclaration.getName().equals(this.name.getName())) {
            return;
        }
        this.ref = xSDeclaration;
        this.manager = null;
        this.name = null;
        this.source = null;
    }

    public static class IdentityConstraint
    extends DelayedRef
    implements Ref.IdentityConstraint {
        public IdentityConstraint(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getIdentityConstraint(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedIdentityConstraint";
        }

        public XSIdentityConstraint get() {
            return (XSIdentityConstraint)super._get();
        }
    }

    public static class Attribute
    extends DelayedRef
    implements Ref.Attribute {
        public Attribute(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getAttributeDecl(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedAttribute";
        }

        public XSAttributeDecl getAttribute() {
            return (XSAttributeDecl)super._get();
        }
    }

    public static class AttGroup
    extends DelayedRef
    implements Ref.AttGroup {
        public AttGroup(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getAttGroupDecl(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedAttributeGroup";
        }

        public XSAttGroupDecl get() {
            return (XSAttGroupDecl)super._get();
        }
    }

    public static class ModelGroup
    extends DelayedRef
    implements Ref.Term {
        public ModelGroup(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getModelGroupDecl(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedModelGroup";
        }

        public XSModelGroupDecl get() {
            return (XSModelGroupDecl)super._get();
        }

        public XSTerm getTerm() {
            return this.get();
        }
    }

    public static class Element
    extends DelayedRef
    implements Ref.Element {
        public Element(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getElementDecl(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedElement";
        }

        public XSElementDecl get() {
            return (XSElementDecl)super._get();
        }

        public XSTerm getTerm() {
            return this.get();
        }
    }

    public static class ComplexType
    extends DelayedRef
    implements Ref.ComplexType {
        public ComplexType(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getComplexType(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedCompplexType";
        }

        public XSComplexType getType() {
            return (XSComplexType)super._get();
        }
    }

    public static class SimpleType
    extends DelayedRef
    implements Ref.SimpleType {
        public SimpleType(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        public XSSimpleType getType() {
            return (XSSimpleType)this._get();
        }

        protected Object resolveReference(UName uName) {
            return this.schema.getSimpleType(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedSimpleType";
        }
    }

    public static class Type
    extends DelayedRef
    implements Ref.Type {
        public Type(PatcherManager patcherManager, Locator locator, SchemaImpl schemaImpl, UName uName) {
            super(patcherManager, locator, schemaImpl, uName);
        }

        protected Object resolveReference(UName uName) {
            XSSimpleType xSSimpleType = this.schema.getSimpleType(uName.getNamespaceURI(), uName.getName());
            if (xSSimpleType != null) {
                return xSSimpleType;
            }
            return this.schema.getComplexType(uName.getNamespaceURI(), uName.getName());
        }

        protected String getErrorProperty() {
            return "UndefinedType";
        }

        public XSType getType() {
            return (XSType)super._get();
        }
    }
}

