/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.parser;

import com.sun.xml.internal.xsom.impl.parser.Messages;
import com.sun.xml.internal.xsom.parser.XMLParser;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class JAXPParser
implements XMLParser {
    private final SAXParserFactory factory;

    public JAXPParser(SAXParserFactory sAXParserFactory) {
        sAXParserFactory.setNamespaceAware(true);
        this.factory = sAXParserFactory;
    }

    public JAXPParser() {
        this(SAXParserFactory.newInstance());
    }

    public void parse(InputSource inputSource, ContentHandler contentHandler, ErrorHandler errorHandler, EntityResolver entityResolver) throws SAXException, IOException {
        try {
            XMLReader xMLReader = this.factory.newSAXParser().getXMLReader();
            xMLReader = new XMLReaderEx(xMLReader);
            xMLReader.setContentHandler(contentHandler);
            if (errorHandler != null) {
                xMLReader.setErrorHandler(errorHandler);
            }
            if (entityResolver != null) {
                xMLReader.setEntityResolver(entityResolver);
            }
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SAXParseException sAXParseException = new SAXParseException(parserConfigurationException.getMessage(), null, parserConfigurationException);
            errorHandler.fatalError(sAXParseException);
            throw sAXParseException;
        }
    }

    private static class XMLReaderEx
    extends XMLFilterImpl {
        private Locator locator;

        XMLReaderEx(XMLReader xMLReader) {
            this.setParent(xMLReader);
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            try {
                InputSource inputSource = null;
                if (this.getEntityResolver() != null) {
                    inputSource = this.getEntityResolver().resolveEntity(string, string2);
                }
                if (inputSource != null) {
                    return inputSource;
                }
                inputSource = new InputSource(new URL(string2).openStream());
                inputSource.setSystemId(string2);
                inputSource.setPublicId(string);
                return inputSource;
            }
            catch (IOException iOException) {
                SAXParseException sAXParseException = new SAXParseException(Messages.format("EntityResolutionFailure", string2, iOException.toString()), this.locator, iOException);
                if (this.getErrorHandler() != null) {
                    this.getErrorHandler().fatalError(sAXParseException);
                }
                throw sAXParseException;
            }
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }
    }
}

