/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap;

import java.io.DataInputStream;
import java.io.IOException;
import sun.tools.javap.JavapPrinter;
import sun.tools.javap.MethodData;
import sun.tools.javap.StackMapData;

class StackMapTableData {
    final int frameType;
    int offsetDelta;

    StackMapTableData(int n) {
        this.frameType = n;
    }

    void print(JavapPrinter javapPrinter) {
        javapPrinter.out.print("   frame_type = " + this.frameType);
    }

    static StackMapTableData getInstance(DataInputStream dataInputStream, MethodData methodData) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n < 64) {
            return new SameFrame(n, n);
        }
        if (64 <= n && n < 128) {
            return new SameLocals1StackItem(n, n - 64, StackMapData.readTypeArray(dataInputStream, 1, methodData));
        }
        if (n == 247) {
            return new SameLocals1StackItem(n, dataInputStream.readUnsignedShort(), StackMapData.readTypeArray(dataInputStream, 1, methodData));
        }
        if (247 < n && n < 251) {
            return new ChopFrame(n, dataInputStream.readUnsignedShort());
        }
        if (n == 251) {
            return new SameFrame(n, dataInputStream.readUnsignedShort());
        }
        if (251 < n && n < 255) {
            return new AppendFrame(n, dataInputStream.readUnsignedShort(), StackMapData.readTypeArray(dataInputStream, n - 251, methodData));
        }
        if (n == 255) {
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.readUnsignedShort();
            int[] nArray = StackMapData.readTypeArray(dataInputStream, n3, methodData);
            int n4 = dataInputStream.readUnsignedShort();
            int[] nArray2 = StackMapData.readTypeArray(dataInputStream, n4, methodData);
            return new FullFrame(n2, nArray, nArray2);
        }
        throw new ClassFormatError("unrecognized frame_type in StackMapTable");
    }

    static class FullFrame
    extends StackMapTableData {
        final int[] locals;
        final int[] stack;

        FullFrame(int n, int[] nArray, int[] nArray2) {
            super(255);
            this.offsetDelta = n;
            this.locals = nArray;
            this.stack = nArray2;
        }

        void print(JavapPrinter javapPrinter) {
            super.print(javapPrinter);
            javapPrinter.out.println(" /* full_frame */");
            javapPrinter.out.println("     offset_delta = " + this.offsetDelta);
            javapPrinter.printMap("     locals = [", this.locals);
            javapPrinter.printMap("     stack = [", this.stack);
        }
    }

    static class AppendFrame
    extends StackMapTableData {
        final int[] locals;

        AppendFrame(int n, int n2, int[] nArray) {
            super(n);
            this.offsetDelta = n2;
            this.locals = nArray;
        }

        void print(JavapPrinter javapPrinter) {
            super.print(javapPrinter);
            javapPrinter.out.println(" /* append */");
            javapPrinter.out.println("     offset_delta = " + this.offsetDelta);
            javapPrinter.printMap("     locals = [", this.locals);
        }
    }

    static class ChopFrame
    extends StackMapTableData {
        ChopFrame(int n, int n2) {
            super(n);
            this.offsetDelta = n2;
        }

        void print(JavapPrinter javapPrinter) {
            super.print(javapPrinter);
            javapPrinter.out.println(" /* chop */");
            javapPrinter.out.println("     offset_delta = " + this.offsetDelta);
        }
    }

    static class SameLocals1StackItem
    extends StackMapTableData {
        final int[] stack;

        SameLocals1StackItem(int n, int n2, int[] nArray) {
            super(n);
            this.offsetDelta = n2;
            this.stack = nArray;
        }

        void print(JavapPrinter javapPrinter) {
            super.print(javapPrinter);
            if (this.frameType == 247) {
                javapPrinter.out.println(" /* same_locals_1_stack_item_frame_extended */");
                javapPrinter.out.println("     offset_delta = " + this.offsetDelta);
            } else {
                javapPrinter.out.println(" /* same_locals_1_stack_item */");
            }
            javapPrinter.printMap("     stack = [", this.stack);
        }
    }

    static class SameFrame
    extends StackMapTableData {
        SameFrame(int n, int n2) {
            super(n);
            this.offsetDelta = n2;
        }

        void print(JavapPrinter javapPrinter) {
            super.print(javapPrinter);
            if (this.frameType < 64) {
                javapPrinter.out.println(" /* same */");
            } else {
                javapPrinter.out.println(" /* same_frame_extended */");
                javapPrinter.out.println("     offset_delta = " + this.offsetDelta);
            }
        }
    }
}

