/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.Instruction;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefnNode
extends MethodDefNode
implements INameNode {
    private final Visibility visibility;

    public DefnNode(ISourcePosition position, ArgumentNode nameNode, ArgsNode argsNode, StaticScope scope, Node bodyNode, Visibility visibility) {
        super(position, nameNode, argsNode, scope, bodyNode, NodeType.DEFNNODE);
        this.visibility = visibility;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDefnNode(this);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public String getName() {
        return this.nameNode.getName();
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.nameNode, this.argsNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule containingClass = context.getRubyClass();
        if (containingClass == runtime.getDummy()) {
            throw runtime.newTypeError("no class/module to add method");
        }
        String name = this.getName();
        if (containingClass == runtime.getObject() && name == "initialize") {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop", "Object#initialize");
        }
        if (name == "__id__" || name == "__send__") {
            runtime.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining `" + name + "' may cause serious problem", name);
        }
        Visibility visibility = context.getCurrentVisibility();
        if (name == "initialize" || name == "initialize_copy" || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        this.scope.determineModule();
        Node body = this.bodyNode == null ? new NilNode(this.getPosition()) : this.bodyNode;
        DefaultMethod newMethod = new DefaultMethod(containingClass, this.scope, body, this.argsNode, visibility, this.getPosition());
        containingClass.addMethod(name, newMethod);
        if (context.getCurrentVisibility() == Visibility.MODULE_FUNCTION) {
            containingClass.getSingletonClass().addMethod(name, new WrapperMethod((RubyModule)containingClass.getSingletonClass(), newMethod, Visibility.PUBLIC));
            containingClass.callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        }
        if (containingClass.isSingleton()) {
            ((MetaClass)containingClass).getAttached().callMethod(context, "singleton_method_added", runtime.fastNewSymbol(name));
        } else {
            containingClass.callMethod(context, "method_added", runtime.fastNewSymbol(name));
        }
        return runtime.getNil();
    }
}

