/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListNode
extends Node {
    private List<Node> list = new ArrayList<Node>(0);

    public ListNode(ISourcePosition position, NodeType id, Node firstNode) {
        this(position, id);
        this.list = new ArrayList<Node>(4);
        this.list.add(firstNode);
    }

    public ListNode(ISourcePosition position, NodeType id) {
        super(position, id);
    }

    public ListNode(ISourcePosition position) {
        this(position, NodeType.LISTNODE);
    }

    public ListNode add(Node node) {
        if (node == null) {
            return this;
        }
        this.list.add(node);
        if (this.getPosition() == null) {
            this.setPosition(node.getPosition());
        } else {
            this.setPosition(this.getPosition().union(node.getPosition()));
        }
        return this;
    }

    public ListNode prepend(Node node) {
        if (node == null) {
            return this;
        }
        this.list.add(0, node);
        this.setPosition(this.getPosition().union(node.getPosition()));
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public ListNode addAll(ListNode other) {
        if (other != null && other.size() > 0) {
            this.list.addAll(other.list);
            this.setPosition(this.getPosition().union(this.getLast().getPosition()));
        }
        return this;
    }

    public ListNode addAll(Node other) {
        return this.add(other);
    }

    public Node getLast() {
        return this.list.size() == 0 ? null : this.list.get(this.list.size() - 1);
    }

    @Override
    public String toString() {
        String string = super.toString();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            b.append(this.list.get(i));
            if (i + 1 >= this.list.size()) continue;
            b.append(", ");
        }
        return string + ": {" + b.toString() + "}";
    }

    @Override
    public List<Node> childNodes() {
        return this.list;
    }

    @Override
    public Instruction accept(NodeVisitor visitor) {
        throw new RuntimeException("Base class ListNode should never be evaluated");
    }

    public Node get(int idx) {
        return this.list.get(idx);
    }
}

