/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.internal.runtime.ThreadLike;

public class FutureThread
implements ThreadLike {
    private volatile Future future;
    private RubyRunnable runnable;
    public RubyThread rubyThread;
    private final Object startingLock = new Object();

    public FutureThread(RubyThread rubyThread, RubyRunnable runnable) {
        this.rubyThread = rubyThread;
        this.runnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.startingLock;
        synchronized (object) {
            this.future = this.rubyThread.getRuntime().getExecutor().submit(this.runnable);
        }
    }

    public void interrupt() {
        if (this.runnable.getJavaThread() != null) {
            this.runnable.getJavaThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Object object = this.startingLock;
        synchronized (object) {
            return this.future != null && !this.future.isDone();
        }
    }

    public void join() throws InterruptedException, ExecutionException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    public void join(long millis) throws InterruptedException, ExecutionException {
        if (millis == 0L) {
            this.join();
        } else {
            try {
                this.future.get(millis, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException ce) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    public int getPriority() {
        return 1;
    }

    public void setPriority(int priority) {
    }

    public boolean isCurrent() {
        return this.rubyThread == this.rubyThread.getRuntime().getCurrentContext().getThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.startingLock;
        synchronized (object) {
            return this.future.isCancelled();
        }
    }
}

