/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashSet<T>
implements Set<T> {
    private WeakHashMap<T, T> map = new WeakHashMap();

    @Override
    public boolean add(T o) {
        Object previousValue = this.map.put(o, null);
        return previousValue == null;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        boolean contains = this.contains(o);
        this.map.remove(o);
        return contains;
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.map.keySet().removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.map.keySet().retainAll(collection);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public boolean containsAll(Collection arg0) {
        return this.map.keySet().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        boolean added = false;
        for (T i : arg0) {
            this.add(i);
            added = true;
        }
        return added;
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.map.keySet().toArray(arg0);
    }
}

