/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBParse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CBXMLFormatter {
    private String tab = "    ";
    private String newLine = System.getProperty("line.separator");
    private static CBXMLFormatter printer;
    private static Writer writer;

    public static void print(Node element) {
        if (printer == null) {
            printer = new CBXMLFormatter();
        }
        if (writer == null) {
            writer = new OutputStreamWriter(System.out);
        }
        try {
            printer.serializeNode(element, writer, "    ");
            writer.flush();
        }
        catch (IOException e) {
            System.err.println("IO exception writing to stdout: " + e);
        }
    }

    public static String dumpToString(Node element) {
        if (printer == null) {
            printer = new CBXMLFormatter();
        }
        if (writer == null) {
            writer = new OutputStreamWriter(System.out);
        }
        try {
            return printer.serializeNode(element, new StringBuffer(), "    ").toString();
        }
        catch (IOException e) {
            System.err.println("IO exception writing to stdout: " + e);
            return "<error/>";
        }
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public void printXML(Document domTree) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        this.printXML(domTree, writer);
    }

    public void printXML(Document domTree, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        this.printXML(domTree, writer);
    }

    public void printXML(Document domTree, Writer writer) throws IOException {
        this.serializeNode((Node)domTree, writer, "");
        writer.flush();
    }

    public void serializeNode(Node node, Writer writer, String tabs) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                writer.write("<?xml version=\"1.0\"?>" + this.newLine);
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int nodeNo = 0; nodeNo < nodes.getLength(); ++nodeNo) {
                    this.serializeNode(nodes.item(nodeNo), writer, "");
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                writer.write(tabs + "<" + name);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    writer.write(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\"");
                }
                writer.write(">");
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        writer.write(this.newLine);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), writer, tabs + this.tab);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        writer.write(tabs);
                    }
                }
                writer.write("</" + name + ">");
                writer.write(this.newLine);
                break;
            }
            case 3: {
                writer.write(node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("<![CDATA[" + node.getNodeValue() + "]]>");
                break;
            }
            case 8: {
                writer.write(tabs + "<!-- " + node.getNodeValue() + " -->");
                writer.write(this.newLine);
                break;
            }
            case 7: {
                writer.write("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
                writer.write(this.newLine);
                break;
            }
            case 5: {
                writer.write("&" + node.getNodeName() + ";");
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                writer.write("<!DOCTYPE " + docType.getName());
                if (docType.getPublicId() != null) {
                    System.out.print(" PUBLIC \"" + docType.getPublicId() + "\" ");
                } else {
                    writer.write(" SYSTEM ");
                }
                writer.write("\"" + docType.getSystemId() + "\">");
                writer.write(this.newLine);
            }
        }
    }

    public StringBuffer serializeNode(Node node, StringBuffer buffy, String tabs) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                buffy.append("<?xml version=\"1.0\"?>" + this.newLine);
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                for (int nodeNo = 0; nodeNo < nodes.getLength(); ++nodeNo) {
                    this.serializeNode(nodes.item(nodeNo), buffy, "");
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                buffy.append(tabs + CBParse.toHTML("<" + name));
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    buffy.append(CBParse.toHTML(" " + current.getNodeName() + "=\"" + current.getNodeValue() + "\""));
                }
                buffy.append(CBParse.toHTML(">"));
                NodeList children = node.getChildNodes();
                if (children != null) {
                    if (children.item(0) != null && children.item(0).getNodeType() == 1) {
                        buffy.append(this.newLine);
                    }
                    for (int i = 0; i < children.getLength(); ++i) {
                        this.serializeNode(children.item(i), buffy, tabs + this.tab);
                    }
                    if (children.item(0) != null && children.item(children.getLength() - 1).getNodeType() == 1) {
                        buffy.append(tabs);
                    }
                }
                buffy.append(CBParse.toHTML("</" + name + ">"));
                buffy.append(this.newLine);
                break;
            }
            case 3: {
                buffy.append(CBParse.toHTML(node.getNodeValue()));
                break;
            }
            case 4: {
                buffy.append(CBParse.toHTML("<![CDATA[" + node.getNodeValue() + "]]>"));
                break;
            }
            case 8: {
                buffy.append(tabs + CBParse.toHTML("<!-- " + node.getNodeValue() + " -->"));
                buffy.append(this.newLine);
                break;
            }
            case 7: {
                buffy.append(CBParse.toHTML("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>"));
                buffy.append(this.newLine);
                break;
            }
            case 5: {
                buffy.append(CBParse.toHTML("&" + node.getNodeName() + ";"));
                break;
            }
            case 10: {
                DocumentType docType = (DocumentType)node;
                buffy.append(CBParse.toHTML("<!DOCTYPE " + docType.getName()));
                if (docType.getPublicId() != null) {
                    System.out.print(" PUBLIC \"" + docType.getPublicId() + "\" ");
                } else {
                    buffy.append(CBParse.toHTML(" SYSTEM "));
                }
                buffy.append(CBParse.toHTML("\"" + docType.getSystemId() + "\">"));
                buffy.append(this.newLine);
            }
        }
        return buffy;
    }
}

