/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.ISignatureCodec;
import gnu.java.security.sig.SignatureFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class SignatureAdapter
extends SignatureSpi
implements Cloneable {
    private static final Logger log;
    private ISignature adaptee;
    private ISignatureCodec codec;
    static /* synthetic */ Class class$gnu$java$security$jce$sig$SignatureAdapter;

    public Object clone() {
        return new SignatureAdapter((ISignature)this.adaptee.clone(), this.codec);
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.sig.public.key", publicKey);
        try {
            this.adaptee.setupVerify(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(String.valueOf(illegalArgumentException));
        }
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.sig.private.key", privateKey);
        try {
            this.adaptee.setupSign(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(String.valueOf(illegalArgumentException));
        }
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.sig.private.key", privateKey);
        hashMap.put("gnu.crypto.sig.prng", secureRandom);
        try {
            this.adaptee.setupSign(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(String.valueOf(illegalArgumentException));
        }
    }

    public void engineUpdate(byte by) throws SignatureException {
        try {
            this.adaptee.update(by);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(String.valueOf(illegalStateException));
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.adaptee.update(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(String.valueOf(illegalStateException));
        }
    }

    public byte[] engineSign() throws SignatureException {
        Object object = null;
        try {
            object = this.adaptee.sign();
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(String.valueOf(illegalStateException));
        }
        byte[] byArray = this.codec.encodeSignature(object);
        return byArray;
    }

    public int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.engineSign();
        int n3 = byArray2.length;
        if (n3 > n2) {
            throw new SignatureException("len");
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        return n3;
    }

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        log.entering("SignatureAdapter", "engineVerify");
        Object object = this.codec.decodeSignature(byArray);
        boolean bl = false;
        try {
            bl = this.adaptee.verify(object);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(String.valueOf(illegalStateException));
        }
        log.exiting("SignatureAdapter", "engineVerify", new Boolean(bl));
        return bl;
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("deprecated");
    }

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("deprecated");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected SignatureAdapter(String string, ISignatureCodec iSignatureCodec) {
        this(SignatureFactory.getInstance(string), iSignatureCodec);
    }

    private SignatureAdapter(ISignature iSignature, ISignatureCodec iSignatureCodec) {
        this.adaptee = iSignature;
        this.codec = iSignatureCodec;
    }

    static {
        Class clazz = class$gnu$java$security$jce$sig$SignatureAdapter;
        if (clazz == null) {
            clazz = class$gnu$java$security$jce$sig$SignatureAdapter = SignatureAdapter.class("[Lgnu.java.security.jce.sig.SignatureAdapter;", false);
        }
        log = Logger.getLogger(clazz.getName());
    }
}

