/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key;

import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import gnu.java.security.key.rsa.RSAKeyPairX509Codec;
import gnu.java.security.util.FormatUtil;
import java.lang.reflect.Constructor;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyPairCodecFactory {
    private static Set names;

    public static IKeyPairCodec getInstance(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (string.startsWith("/")) {
            return null;
        }
        if (string.endsWith("/")) {
            return KeyPairCodecFactory.getInstance(string.substring(0, string.length() - 1), 1);
        }
        int n = string.indexOf("/");
        if (n == -1) {
            return KeyPairCodecFactory.getInstance(string, 1);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return KeyPairCodecFactory.getInstance(string2, string3);
    }

    public static IKeyPairCodec getInstance(String string, String string2) {
        int n = FormatUtil.getFormatID(string2);
        if (n == 0) {
            return null;
        }
        return KeyPairCodecFactory.getInstance(string, n);
    }

    public static IKeyPairCodec getInstance(String string, int n) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        switch (n) {
            case 1: {
                return KeyPairCodecFactory.getRawCodec(string);
            }
            case 2: {
                return KeyPairCodecFactory.getX509Codec(string);
            }
            case 3: {
                return KeyPairCodecFactory.getPKCS8Codec(string);
            }
        }
        return null;
    }

    public static IKeyPairCodec getInstance(Key key) {
        if (key == null) {
            return null;
        }
        String string = key.getFormat();
        int n = FormatUtil.getFormatID(string);
        if (n == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return KeyPairCodecFactory.getRawCodec(key);
            }
            case 2: {
                return KeyPairCodecFactory.getX509Codec(key);
            }
            case 3: {
                return KeyPairCodecFactory.getPKCS8Codec(key);
            }
        }
        return null;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet hashSet = new HashSet();
            hashSet.add("dss/RAW");
            hashSet.add("dss/X.509");
            hashSet.add("dss/PKCS#8");
            hashSet.add("rsa/RAW");
            hashSet.add("rsa/X.509");
            hashSet.add("rsa/PKCS#8");
            hashSet.add("dh/RAW");
            hashSet.add("srp/RAW");
            names = Collections.unmodifiableSet(hashSet);
        }
        return names;
    }

    private static final IKeyPairCodec makeInstance(String string) {
        try {
            Class clazz = Class.forName(string);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (IKeyPairCodec)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("strong crypto key codec not available: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    private static final boolean matches(Object object, String string) {
        try {
            Class clazz = Class.forName(string);
            return clazz.isAssignableFrom(object.getClass());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final IKeyPairCodec getRawCodec(String string) {
        IKeyPairCodec iKeyPairCodec = null;
        if (string.equalsIgnoreCase("dsa") || string.equals("dss")) {
            iKeyPairCodec = new DSSKeyPairRawCodec();
        } else if (string.equalsIgnoreCase("rsa")) {
            iKeyPairCodec = new RSAKeyPairRawCodec();
        } else if (string.equalsIgnoreCase("dh")) {
            iKeyPairCodec = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairRawCodec");
        } else if (string.equalsIgnoreCase("srp")) {
            iKeyPairCodec = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec");
        }
        return iKeyPairCodec;
    }

    private static final IKeyPairCodec getX509Codec(String string) {
        IKeyPairCodec iKeyPairCodec = null;
        if (string.equalsIgnoreCase("dsa") || string.equals("dss")) {
            iKeyPairCodec = new DSSKeyPairX509Codec();
        } else if (string.equalsIgnoreCase("rsa")) {
            iKeyPairCodec = new RSAKeyPairX509Codec();
        } else if (string.equalsIgnoreCase("dh")) {
            iKeyPairCodec = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairX509Codec");
        }
        return iKeyPairCodec;
    }

    private static final IKeyPairCodec getPKCS8Codec(String string) {
        IKeyPairCodec iKeyPairCodec = null;
        if (string.equalsIgnoreCase("dsa") || string.equals("dss")) {
            iKeyPairCodec = new DSSKeyPairPKCS8Codec();
        } else if (string.equalsIgnoreCase("rsa")) {
            iKeyPairCodec = new RSAKeyPairPKCS8Codec();
        } else if (string.equalsIgnoreCase("dh")) {
            iKeyPairCodec = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairPKCS8Codec");
        }
        return iKeyPairCodec;
    }

    private static final IKeyPairCodec getRawCodec(Key key) {
        IKeyPairCodec iKeyPairCodec = null;
        if (key instanceof DSSPublicKey || key instanceof DSSPrivateKey) {
            iKeyPairCodec = new DSSKeyPairRawCodec();
        } else if (key instanceof GnuRSAPublicKey || key instanceof GnuRSAPrivateKey) {
            iKeyPairCodec = new RSAKeyPairRawCodec();
        } else if (KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.dh.GnuDHPublicKey") || KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.dh.GnuDHPrivateKey")) {
            iKeyPairCodec = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.dh.DHKeyPairRawCodec");
        } else if (KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.srp6.SRPPublicKey") || KeyPairCodecFactory.matches(key, "gnu.javax.crypto.key.srp6.SRPPrivateKey")) {
            iKeyPairCodec = KeyPairCodecFactory.makeInstance("gnu.javax.crypto.key.srp6.SRPKeyPairRawCodec");
        }
        return iKeyPairCodec;
    }

    private static final IKeyPairCodec getX509Codec(Key key) {
        IKeyPairCodec iKeyPairCodec = null;
        if (key instanceof DSSPublicKey) {
            iKeyPairCodec = new DSSKeyPairX509Codec();
        } else if (key instanceof GnuRSAPublicKey) {
            iKeyPairCodec = new RSAKeyPairX509Codec();
        }
        return iKeyPairCodec;
    }

    private static final IKeyPairCodec getPKCS8Codec(Key key) {
        IKeyPairCodec iKeyPairCodec = null;
        if (key instanceof DSSPrivateKey) {
            iKeyPairCodec = new DSSKeyPairPKCS8Codec();
        } else if (key instanceof GnuRSAPrivateKey) {
            iKeyPairCodec = new RSAKeyPairPKCS8Codec();
        }
        return iKeyPairCodec;
    }

    private KeyPairCodecFactory() {
    }
}

