/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.Registry;
import gnu.java.security.key.dss.DSSKey;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import gnu.java.security.key.dss.DSSKeyPairX509Codec;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;

public class DSSPublicKey
extends DSSKey
implements PublicKey,
DSAPublicKey {
    private final BigInteger y;

    public static DSSPublicKey valueOf(byte[] byArray) {
        if (byArray[0] == Registry.MAGIC_RAW_DSS_PUBLIC_KEY[0]) {
            try {
                return (DSSPublicKey)new DSSKeyPairRawCodec().decodePublicKey(byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (DSSPublicKey)new DSSKeyPairX509Codec().decodePublicKey(byArray);
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded(int n) {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new DSSKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            case 2: {
                byArray = new DSSKeyPairX509Codec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + n);
            }
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
        boolean bl = false;
        if (super.equals(dSAPublicKey) && this.y.equals(dSAPublicKey.getY())) {
            bl = true;
        }
        return bl;
    }

    public DSSPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(1, bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public DSSPublicKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(n == 4 ? 2 : n, bigInteger, bigInteger2, bigInteger3);
        this.y = bigInteger4;
    }
}

