/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.font.TextHitInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;

public class InputMethodEvent
extends AWTEvent {
    private static final long serialVersionUID = 4727190874778922661L;
    public static final int INPUT_METHOD_FIRST = 1100;
    public static final int INPUT_METHOD_TEXT_CHANGED = 1100;
    public static final int CARET_POSITION_CHANGED = 1101;
    public static final int INPUT_METHOD_LAST = 1101;
    private long when;
    private final transient AttributedCharacterIterator text;
    private final transient int committedCharacterCount;
    private final transient TextHitInfo caret;
    private final transient TextHitInfo visiblePosition;

    public AttributedCharacterIterator getText() {
        return this.text;
    }

    public int getCommittedCharacterCount() {
        return this.committedCharacterCount;
    }

    public TextHitInfo getCaret() {
        return this.caret;
    }

    public TextHitInfo getVisiblePosition() {
        return this.visiblePosition;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        int n = 0;
        if (this.text != null) {
            n = this.text.getEndIndex() - this.text.getBeginIndex();
        }
        StringBuffer stringBuffer = new StringBuffer(80 + n);
        stringBuffer.append(this.id == 1100 ? "INPUT_METHOD_TEXT_CHANGED, " : "CARET_POSITION_CHANGED, ");
        if (this.text == null) {
            stringBuffer.append("no text, 0 characters committed, caret: ");
        } else {
            stringBuffer.append('\"');
            int n2 = this.text.getBeginIndex();
            int n3 = this.committedCharacterCount;
            while (--n3 >= 0) {
                stringBuffer.append(this.text.setIndex(n2++));
            }
            stringBuffer.append("\" + \"");
            n3 = this.text.getEndIndex() - n2;
            while (--n3 >= 0) {
                stringBuffer.append(this.text.setIndex(n2++));
            }
            stringBuffer.append("\", ").append(this.committedCharacterCount).append(" characters committed, caret: ");
        }
        stringBuffer.append(this.caret == null ? "no caret" : this.caret).append(", ").append(this.visiblePosition == null ? "no visible position" : this.visiblePosition);
        return stringBuffer.toString();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.when == 0L) {
            this.when = EventQueue.getMostRecentEventTime();
        }
    }

    public InputMethodEvent(Component component, int n, long l, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        block5: {
            block4: {
                super(component, n);
                this.when = l;
                this.text = attributedCharacterIterator;
                this.committedCharacterCount = n2;
                this.caret = textHitInfo;
                this.visiblePosition = textHitInfo2;
                if (n < 1100 || n > 1101 || n == 1101 && attributedCharacterIterator != null || n2 < 0) break block4;
                int n3 = 0;
                if (attributedCharacterIterator != null) {
                    n3 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
                }
                if (n2 <= n3) break block5;
            }
            throw new IllegalArgumentException();
        }
    }

    public InputMethodEvent(Component component, int n, AttributedCharacterIterator attributedCharacterIterator, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n, EventQueue.getMostRecentEventTime(), attributedCharacterIterator, n2, textHitInfo, textHitInfo2);
    }

    public InputMethodEvent(Component component, int n, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n, EventQueue.getMostRecentEventTime(), null, 0, textHitInfo, textHitInfo2);
    }
}

