/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.ShortBuffer;

final class ShortBufferImpl
extends ShortBuffer {
    private boolean readOnly;

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final ShortBuffer slice() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public final ShortBuffer duplicate() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public final ShortBuffer asReadOnlyBuffer() {
        return new ShortBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public final ShortBuffer compact() {
        this.checkIfReadOnly();
        this.mark = -1;
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        this.limit(this.capacity());
        return this;
    }

    public final boolean isDirect() {
        return false;
    }

    public final short get() {
        this.checkForUnderflow();
        short s = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return s;
    }

    public final ShortBuffer put(short s) {
        this.checkIfReadOnly();
        this.checkForOverflow();
        this.backing_buffer[this.position()] = s;
        this.position(this.position() + 1);
        return this;
    }

    public final short get(int n) {
        this.checkIndex(n);
        return this.backing_buffer[n];
    }

    public final ShortBuffer put(int n, short s) {
        this.checkIfReadOnly();
        this.checkIndex(n);
        this.backing_buffer[n] = s;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    ShortBufferImpl(int n) {
        this(new short[n], 0, n, n, 0, -1, false);
    }

    ShortBufferImpl(short[] sArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n2, n3, n4, n5);
        this.backing_buffer = sArray;
        this.array_offset = n;
        this.readOnly = bl;
    }
}

