/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;

public final class StringCharacterIterator
implements CharacterIterator {
    private String text;
    private int begin;
    private int end;
    private int index;

    public final char current() {
        return this.index < this.end ? this.text.charAt(this.index) : (char)-1;
    }

    public final char next() {
        if (this.index == this.end) {
            return (char)-1;
        }
        ++this.index;
        return this.current();
    }

    public final char previous() {
        if (this.index == this.begin) {
            return (char)-1;
        }
        --this.index;
        return this.current();
    }

    public final char first() {
        this.index = this.begin;
        return this.current();
    }

    public final char last() {
        if (this.end == this.begin) {
            return (char)-1;
        }
        this.index = this.end - 1;
        return this.current();
    }

    public final int getIndex() {
        return this.index;
    }

    public final char setIndex(int n) {
        if (n < this.begin || n > this.end) {
            throw new IllegalArgumentException("Bad index specified");
        }
        this.index = n;
        return this.current();
    }

    public final int getBeginIndex() {
        return this.begin;
    }

    public final int getEndIndex() {
        return this.end;
    }

    public final Object clone() {
        return new StringCharacterIterator(this.text, this.begin, this.end, this.index);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof StringCharacterIterator)) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = (StringCharacterIterator)object;
        boolean bl = false;
        if (this.begin == stringCharacterIterator.begin && this.end == stringCharacterIterator.end && this.index == stringCharacterIterator.index && this.text.equals(stringCharacterIterator.text)) {
            bl = true;
        }
        return bl;
    }

    public final int hashCode() {
        return this.begin ^ this.end ^ this.index ^ this.text.hashCode();
    }

    public final void setText(String string) {
        this.text = string;
        this.begin = 0;
        this.end = string.length();
        this.index = 0;
    }

    public StringCharacterIterator(String string) {
        this(string, 0, string.length(), 0);
    }

    public StringCharacterIterator(String string, int n) {
        this(string, 0, string.length(), n);
    }

    public StringCharacterIterator(String string, int n, int n2, int n3) {
        int n4 = string.length();
        if (n < 0 || n > n4) {
            throw new IllegalArgumentException("Bad begin position");
        }
        if (n2 < n || n2 > n4) {
            throw new IllegalArgumentException("Bad end position");
        }
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException("Bad initial index position");
        }
        this.text = string;
        this.begin = n;
        this.end = n2;
        this.index = n3;
    }

    StringCharacterIterator(StringCharacterIterator stringCharacterIterator, int n, int n2) {
        this(stringCharacterIterator.text, n, n2, n);
    }
}

