/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.KeyStore;
import java.security.Security;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    private static SSLContext context;

    public static synchronized ServerSocketFactory getDefault() {
        TrustManager[] trustManagerArray;
        KeyManager[] keyManagerArray;
        try {
            keyManagerArray = Security.getProperty("ssl.ServerSocketFactory.provider");
            trustManagerArray = ClassLoader.getSystemClassLoader();
            if (keyManagerArray != null && trustManagerArray != null) {
                return (ServerSocketFactory)trustManagerArray.loadClass((String)keyManagerArray).newInstance();
            }
        }
        catch (Exception exception) {}
        if (context == null) {
            Object object;
            keyManagerArray = null;
            trustManagerArray = null;
            String string = KeyManagerFactory.getDefaultAlgorithm();
            String string2 = TrustManagerFactory.getDefaultAlgorithm();
            try {
                object = KeyManagerFactory.getInstance(string);
                ((KeyManagerFactory)object).init(null, null);
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            catch (Exception exception) {}
            try {
                object = TrustManagerFactory.getInstance(string2);
                ((TrustManagerFactory)object).init((KeyStore)null);
                trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
            }
            catch (Exception exception) {}
            try {
                context = SSLContext.getInstance("SSLv3");
                context.init(keyManagerArray, trustManagerArray, null);
            }
            catch (Exception exception) {
                throw new RuntimeException("error instantiating default server socket factory: " + exception.toString());
            }
        }
        try {
            return context.getServerSocketFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException("no SSLSocketFactory implementation available");
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    protected SSLServerSocketFactory() {
    }
}

