/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;

public class BasicIconFactory
implements Serializable {
    static final long serialVersionUID = 5605588811185324383L;
    private static CheckBoxIcon checkBoxIcon;
    private static RadioButtonIcon radioButtonIcon;

    public static Icon getMenuItemCheckIcon() {
        return new Icon(){

            public final int getIconHeight() {
                return 13;
            }

            public final int getIconWidth() {
                return 13;
            }

            public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.setColor(Color.BLACK);
                graphics.drawLine(3 + n, 5 + n2, 3 + n, 9 + n2);
                graphics.drawLine(4 + n, 5 + n2, 4 + n, 9 + n2);
                graphics.drawLine(5 + n, 7 + n2, 9 + n, 3 + n2);
                graphics.drawLine(5 + n, 8 + n2, 9 + n, 4 + n2);
                graphics.setColor(color);
            }
        };
    }

    public static Icon getMenuItemArrowIcon() {
        return new DummyIcon();
    }

    public static Icon getMenuArrowIcon() {
        return new Icon(){

            public final int getIconHeight() {
                return 8;
            }

            public final int getIconWidth() {
                return 4;
            }

            public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
                Color color = graphics.getColor();
                graphics.setColor(Color.BLACK);
                int n3 = 0;
                while (n3 < 4) {
                    graphics.drawLine(n + n3, n2 + n3, n + n3, n2 + 7 - n3);
                    ++n3;
                }
                graphics.setColor(color);
            }
        };
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        return new CheckBoxMenuItemIcon();
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return BasicIconFactory.getRadioButtonIcon();
    }

    public static Icon createEmptyFrameIcon() {
        return new DummyIcon();
    }

    private static class DummyIcon
    implements Icon {
        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(component.getForeground());
            graphics.drawRect(n, n2, 10, 10);
            graphics.setColor(color);
        }

        private DummyIcon() {
        }
    }

    static class CheckBoxIcon
    implements Icon {
        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        CheckBoxIcon() {
        }
    }

    static class RadioButtonIcon
    implements Icon {
        public int getIconHeight() {
            return 13;
        }

        public int getIconWidth() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        RadioButtonIcon() {
        }
    }

    static class CheckBoxMenuItemIcon
    implements Icon {
        public int getIconHeight() {
            return 9;
        }

        public int getIconWidth() {
            return 9;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)component;
            if (jCheckBoxMenuItem.isSelected()) {
                graphics.setColor(Color.black);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 4);
                graphics.drawLine(n + 2, n2 + 4, n + 2, n2 + 5);
                int n3 = 0;
                while (n3 < 5) {
                    graphics.drawLine(n + 3 + n3, n2 + 5 - n3, n + 3 + n3, n2 + 6 - n3);
                    ++n3;
                }
            }
        }

        CheckBoxMenuItemIcon() {
        }
    }
}

