/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class IconView
extends View {
    public void paint(Graphics graphics, Shape shape) {
        Icon icon = StyleConstants.getIcon(this.getElement().getAttributes());
        Rectangle rectangle = shape.getBounds();
        icon.paintIcon(this.getContainer(), graphics, rectangle.x, rectangle.y);
    }

    public float getPreferredSpan(int n) {
        float f;
        Icon icon = StyleConstants.getIcon(this.getElement().getAttributes());
        if (n == 0) {
            f = icon.getIconWidth();
        } else if (n == 1) {
            f = icon.getIconHeight();
        } else {
            throw new IllegalArgumentException();
        }
        return f;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Element element = this.getElement();
        Rectangle rectangle = shape.getBounds();
        Icon icon = StyleConstants.getIcon(element.getAttributes());
        return new Rectangle(rectangle.x, rectangle.y, icon.getIconWidth(), icon.getIconHeight());
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Element element = this.getElement();
        return element.getStartOffset();
    }

    public IconView(Element element) {
        super(element);
    }
}

