/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux <klaux@student.uni-kl.de>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _MOVIE_H
#define _MOVIE_H


#include "widget.h"
#include "font.h"
#include "timer.h"

namespace uta {

///
class Movie : public Widget
{
 //OBJECT

 public:
  ///
  Movie(Widget* parent, int x, int y, int w, int h);
  ///
  virtual ~Movie();
  
  ///
  void start();
  ///
  void stop();
  ///
  void load(std::vector<const Surface*>*);
  ///unit is ms
  void setDelay(unsigned int);

  ///
  void tick();
  
 protected:

  ///
  virtual void create();  
  ///
  std::vector<const Surface*> frames_;
  ///
  int index_;
  ///
  Timer myTimer_;
  
};


}


#endif // !_LABEL_H

