/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.common.ProgressPanel;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRequestProcessor {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.persistence.util");
    private static final boolean LOG = LOGGER.isLoggable(1);
    ActionInvoker actionInvoker;

    public void invoke(Collection<Action> actions) {
        this.invoke(actions, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invoke(Collection<Action> actions, boolean cancellable) {
        boolean success;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called in the event thread.");
        }
        if (this.actionInvoker != null) {
            throw new IllegalStateException("The invoke() method is running.");
        }
        this.actionInvoker = new ActionInvoker(new ArrayList<Action>(actions), cancellable);
        try {
            success = this.actionInvoker.invoke();
        }
        finally {
            this.actionInvoker = null;
        }
        return success;
    }

    public static abstract class AsynchronousAction
    implements Action {
        public boolean getRunInEventThread() {
            return false;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public static abstract class SynchronousAction
    implements Action {
        public boolean getRunInEventThread() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public static interface CancellableAction
    extends Action,
    Cancellable {
    }

    public static interface Action {
        public boolean getRunInEventThread();

        public boolean isEnabled();

        public void run(Context var1);
    }

    public static final class Progress {
        private final ProgressPanel panel;
        private final ProgressHandle handle;

        private Progress(ProgressPanel panel, ProgressHandle handle) {
            this.panel = panel;
            this.handle = handle;
        }

        public void switchToDeterminate(int workunits) {
            this.handle.switchToDeterminate(workunits);
        }

        public void progress(final String message) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    Progress.this.panel.setText(message);
                }
            });
            this.handle.progress(message);
        }

        public void progress(int workunit) {
            this.handle.progress(workunit);
        }

        ProgressPanel getPanel() {
            return this.panel;
        }
    }

    public static final class Context {
        private final Progress progress;

        public Context(Progress progress) {
            this.progress = progress;
        }

        public Progress getProgress() {
            return this.progress;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ActionInvoker
    implements ActionListener {
        private final List<Action> actions;
        private final boolean cancellable;
        private Context actionContext;
        private int currentActionIndex;
        private boolean cancelled;

        public ActionInvoker(List<Action> actions, boolean cancellable) {
            this.actions = actions;
            this.cancellable = cancellable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            assert (SwingUtilities.isEventDispatchThread());
            final ProgressPanel progressPanel = new ProgressPanel();
            progressPanel.setCancelVisible(this.cancellable);
            progressPanel.addCancelActionListener(this);
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
            JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
            progressHandle.start();
            progressHandle.switchToIndeterminate();
            this.actionContext = new Context(new Progress(progressPanel, progressHandle));
            final Throwable[] exceptions = new Throwable[1];
            try {
                RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ActionInvoker.this.invokeActionsUntilThreadSwitch();
                        }
                        catch (Throwable t) {
                            try {
                                exceptions[0] = t;
                            }
                            catch (Throwable throwable) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        progressPanel.close();
                                    }
                                });
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                boolean runInEDT = true;
                while (this.currentActionIndex < this.actions.size()) {
                    if (this.cancelled) {
                        break;
                    }
                    try {
                        if (!runInEDT) {
                            task.schedule(0);
                            progressPanel.open(progressComponent);
                        }
                        this.invokeActionsUntilThreadSwitch();
                        if (!runInEDT) {
                            task.waitFinished();
                        }
                    }
                    catch (Throwable t) {
                        exceptions[0] = t;
                    }
                    if (exceptions[0] != null) {
                        if (exceptions[0] instanceof RuntimeException) {
                            throw (RuntimeException)exceptions[0];
                        }
                        RuntimeException exception = new RuntimeException(exceptions[0].getMessage());
                        exception.initCause(exceptions[0]);
                        throw exception;
                    }
                    runInEDT = !runInEDT;
                }
            }
            finally {
                progressHandle.finish();
            }
            return !this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeActionsUntilThreadSwitch() {
            boolean isEventThread = SwingUtilities.isEventDispatchThread();
            while (true) {
                ActionInvoker actionInvoker;
                ActionInvoker actionInvoker2 = this;
                synchronized (actionInvoker2) {
                    if (this.cancelled) {
                        break;
                    }
                }
                if (this.currentActionIndex >= this.actions.size()) break;
                Action action = this.actions.get(this.currentActionIndex);
                if (!action.isEnabled()) {
                    if (LOG) {
                        LOGGER.log("Skipping " + action);
                    }
                    actionInvoker = this;
                    synchronized (actionInvoker) {
                        ++this.currentActionIndex;
                    }
                }
                if (action.getRunInEventThread() != isEventThread) break;
                if (LOG) {
                    LOGGER.log("Running " + action);
                }
                if (!isEventThread) {
                    final boolean cancelEnabled = action instanceof Cancellable;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ActionInvoker.this.actionContext.getProgress().getPanel().setCancelEnabled(cancelEnabled);
                        }
                    });
                }
                action.run(this.actionContext);
                actionInvoker = this;
                synchronized (actionInvoker) {
                    ++this.currentActionIndex;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            ActionInvoker actionInvoker = this;
            synchronized (actionInvoker) {
                if (this.cancelled) {
                    return;
                }
                if (this.currentActionIndex >= this.actions.size()) {
                    return;
                }
                Action currentAction = this.actions.get(this.currentActionIndex);
                if (!currentAction.getRunInEventThread() && currentAction instanceof Cancellable) {
                    this.cancelled = ((Cancellable)currentAction).cancel();
                    if (this.cancelled) {
                        this.actionContext.getProgress().getPanel().setCancelEnabled(false);
                    }
                }
            }
        }
    }
}

