/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.ui.nodes;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FieldCustomizer
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle(FieldCustomizer.class);
    Field element;
    public static final String[] COMMON_TYPES = new String[]{"String", "boolean", "char", "int", "long", "byte", "short", "float", "double"};
    boolean isOK = true;
    private JLabel addToLocalLabel;
    private JLabel addToRemoteLabel;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private JCheckBox localGetterCheckBox;
    private JCheckBox localSetterCheckBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JCheckBox remoteGetterCheckBox;
    private JCheckBox remoteSetterCheckBox;
    private JLabel spacerLabel;
    private JComboBox typeCombo;
    private JLabel typeLabel;

    public FieldCustomizer(Field element, String description, boolean localEnabled, boolean remoteEnabled, boolean localGetter, boolean localSetter, boolean remoteGetter, boolean remoteSetter) {
        this.element = element;
        this.initComponents();
        this.descriptionTextField.setText(description);
        this.localGetterCheckBox.setEnabled(localEnabled);
        this.localSetterCheckBox.setEnabled(localEnabled);
        this.remoteGetterCheckBox.setEnabled(remoteEnabled);
        this.remoteSetterCheckBox.setEnabled(remoteEnabled);
        this.localGetterCheckBox.setSelected(localGetter && localEnabled);
        this.localSetterCheckBox.setSelected(localSetter && localEnabled);
        this.remoteGetterCheckBox.setSelected(remoteGetter && remoteEnabled);
        this.remoteSetterCheckBox.setSelected(remoteSetter && remoteEnabled);
        this.nameTextField.setText(element.getName().toString());
        Type type = element.getType();
        if (type != null) {
            this.typeCombo.setSelectedItem(type.getName());
        }
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int l = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(l);
        this.nameTextField.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FieldCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeCombo = new JComboBox<String>(COMMON_TYPES);
        this.addToLocalLabel = new JLabel();
        this.localGetterCheckBox = new JCheckBox();
        this.localSetterCheckBox = new JCheckBox();
        this.addToRemoteLabel = new JLabel();
        this.remoteGetterCheckBox = new JCheckBox();
        this.remoteSetterCheckBox = new JCheckBox();
        this.spacerLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 8, 0, 8);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(30);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                FieldCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 8);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Name_AD"));
        this.descriptionLabel.setLabelFor(this.descriptionTextField);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Description"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.add((Component)this.descriptionTextField, gridBagConstraints);
        this.descriptionTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Description_AD"));
        this.typeLabel.setLabelFor(this.typeCombo);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Type"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.typeCombo.setEditable(true);
        this.typeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FieldCustomizer.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.add((Component)this.typeCombo, gridBagConstraints);
        this.typeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Type_AD"));
        Mnemonics.setLocalizedText((JLabel)this.addToLocalLabel, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"LBL_AddToLocalInterface"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 8, 0, 8);
        this.add((Component)this.addToLocalLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.localGetterCheckBox, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Getter_Local"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 16, 0, 16);
        this.add((Component)this.localGetterCheckBox, gridBagConstraints);
        this.localGetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizer.class, (String)"Getter_Local_AN"));
        this.localGetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Getter_Local_AD"));
        Mnemonics.setLocalizedText((AbstractButton)this.localSetterCheckBox, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Setter_Local"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 16, 0, 16);
        this.add((Component)this.localSetterCheckBox, gridBagConstraints);
        this.localSetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizer.class, (String)"Setter_Local_AN"));
        this.localSetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Setter_Local_AD"));
        Mnemonics.setLocalizedText((JLabel)this.addToRemoteLabel, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"LBL_AddToRemoteInterface"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(16, 8, 0, 8);
        this.add((Component)this.addToRemoteLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.remoteGetterCheckBox, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Getter_Remote"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 16, 0, 16);
        this.add((Component)this.remoteGetterCheckBox, gridBagConstraints);
        this.remoteGetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizer.class, (String)"Getter_Remote_AN"));
        this.remoteGetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Getter_Remote_AD"));
        Mnemonics.setLocalizedText((AbstractButton)this.remoteSetterCheckBox, (String)NbBundle.getMessage(FieldCustomizer.class, (String)"CTL_Setter_Remote"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 16, 0, 16);
        this.add((Component)this.remoteSetterCheckBox, gridBagConstraints);
        this.remoteSetterCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FieldCustomizer.class, (String)"Setter_Remote_AN"));
        this.remoteSetterCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FieldCustomizer.class, (String)"Setter_Remote_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.spacerLabel, gridBagConstraints);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Object selItem = this.typeCombo.getSelectedItem();
        Type oldValue = this.element.getType();
        boolean ok = false;
        if (selItem != null) {
            try {
                Type newValue = JMIUtils.resolveType((String)this.typeCombo.getSelectedItem());
                if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                this.element.setType(newValue);
                ok = true;
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().annotate((Throwable)e, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.typeCombo.setSelectedItem(oldValue.toString());
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && evt.isTemporary()) {
            return;
        }
        String newName = this.nameTextField.getText();
        String oldName = this.element.getName().toString();
        if (!oldName.equals(newName)) {
            IllegalArgumentException x = FieldCustomizer.validateFieldName(newName);
            if (x == null) {
                this.element.setName(newName);
            }
            if (x != null) {
                this.isOK = false;
                this.nameTextField.setText(oldName);
                ErrorManager.getDefault().notify((Throwable)x);
            } else {
                this.isOK = true;
            }
        }
    }

    public static IllegalArgumentException validateFieldName(String newName) {
        Object messageId = Utilities.isJavaIdentifier((String)newName) ? (Character.isLowerCase(newName.charAt(0)) ? null : "MSG_Field_Starts_Upper") : "MSG_Not_Valid_Identifier";
        if (messageId != null) {
            IllegalArgumentException x = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, bundle.getString((String)messageId), null, null);
            return x;
        }
        return null;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AddFieldDialog"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        boolean result = this.isOK;
        this.jComboBox1ActionPerformed(null);
        result = result && this.isOK;
        return result;
    }

    public String getDescription() {
        return this.descriptionTextField.getText();
    }

    public boolean isLocalGetter() {
        return this.localGetterCheckBox.isSelected();
    }

    public boolean isLocalSetter() {
        return this.localSetterCheckBox.isSelected();
    }

    public boolean isRemoteGetter() {
        return this.remoteGetterCheckBox.isSelected();
    }

    public boolean isRemoteSetter() {
        return this.remoteSetterCheckBox.isSelected();
    }
}

