/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.dm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ResourceConfiguratorInterface;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.SunURIManager;
import org.netbeans.modules.j2ee.sun.appsrvapi.PortDetector;
import org.netbeans.modules.j2ee.sun.ide.dm.Constants;
import org.netbeans.modules.j2ee.sun.ide.editors.AdminAuthenticator;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DeploymentManagerProperties;
import org.netbeans.modules.j2ee.sun.ide.j2ee.DomainEditor;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ProgressEventSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.StartSunServer;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.JvmOptions;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.ServerInfo;
import org.netbeans.modules.j2ee.sun.ide.j2ee.runtime.actions.ViewLogAction;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceConfigurator;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.plan.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SunDeploymentManager
implements Constants,
DeploymentManager,
SunDeploymentManagerInterface {
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private DeploymentManager innerDM;
    private DeploymentFactory df;
    private String host;
    private String userName;
    private String password;
    private String uri;
    private boolean isConnected;
    private static Map passwordForURI = Collections.synchronizedMap(new HashMap(2, 1.0f));
    int adminPortNumber;
    String nonAdminPortNumber = null;
    private static String SECURESTRINGDETECTION = ":https";
    private transient boolean secureStatusHasBeenChecked = false;
    private boolean runningState = false;
    private boolean secure = false;
    private boolean goodUserNamePassword = false;
    private boolean maybeRunningButWrongUserName = false;
    private long timeStampCheckingRunning = 0L;
    private File platformRoot = null;
    private boolean isGlassFish = false;
    private boolean isLocal = false;
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.dm.Bundle");
    String lastAddress = null;
    boolean lastIsSharedMem = false;
    private ServerInterface mmm = null;
    private ResourceConfiguratorInterface resourceConfigurator = null;
    private static String PROP_INSTANCE_ID = "PROP_INSTANCE_ID";

    public SunDeploymentManager(DeploymentFactory df, String uri, String userName, String password, File platformRootDir) throws DeploymentManagerCreationException {
        this.df = df;
        this.uri = uri;
        this.platformRoot = platformRootDir;
        this.isGlassFish = ServerLocationManager.isGlassFish((File)platformRootDir);
        this.secure = uri.endsWith(SECURESTRINGDETECTION);
        String uriNonSecure = uri;
        if (this.secure) {
            uriNonSecure = uri.substring(0, uri.length() - SECURESTRINGDETECTION.length());
        }
        this.host = SunDeploymentManager.getHostFromURI(uriNonSecure);
        this.adminPortNumber = SunDeploymentManager.getPortFromURI(uriNonSecure);
        try {
            InstanceProperties props = SunURIManager.getInstanceProperties((File)this.platformRoot, (String)this.host, (int)this.adminPortNumber);
            this.userName = userName == null && props != null ? props.getProperty("username") : userName;
            this.password = password == null && props != null ? props.getProperty("password") : password;
            if (!"".equals(this.password)) {
                passwordForURI.put(uri + this.platformRoot, this.password);
            } else {
                this.password = (String)passwordForURI.get(uri + this.platformRoot);
                if (this.password == null) {
                    this.password = "";
                }
            }
            this.isConnected = this.userName != null;
        }
        catch (IllegalStateException ise) {
            ErrorManager.getDefault().notify(1, (Throwable)ise);
        }
        this.resetInnerDeploymentManager();
        this.calculateIsLocal();
    }

    private void resetInnerDeploymentManager() throws DeploymentManagerCreationException {
        try {
            if (this.isConnected) {
                if (this.df != null) {
                    this.innerDM = this.df.getDeploymentManager(this.uri, this.userName, this.password);
                }
            } else if (this.df != null) {
                this.innerDM = this.df.getDisconnectedDeploymentManager(this.uri);
            }
        }
        catch (NoClassDefFoundError ee) {
            throw ee;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentManagerCreationException("DeploymentManagerCreationException" + e.getMessage());
        }
        if (this.secure) {
            try {
                Class[] argClass = new Class[]{DeploymentManager.class};
                Object[] argObject = new Object[]{this.innerDM};
                ClassLoader loader = this.getExtendedClassLoader();
                if (loader != null) {
                    Class<?> cc = loader.loadClass("org.netbeans.modules.j2ee.sun.bridge.AppServerBridge");
                    Method setServerConnectionEnvironment = cc.getMethod("setServerConnectionEnvironment", argClass);
                    setServerConnectionEnvironment.invoke(null, argObject);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getUserName() {
        InstanceProperties props = SunURIManager.getInstanceProperties((File)this.platformRoot, (String)this.host, (int)this.adminPortNumber);
        if (null != props) {
            this.userName = props.getProperty("username");
        }
        return this.userName;
    }

    public String getPassword() {
        InstanceProperties props = SunURIManager.getInstanceProperties((File)this.platformRoot, (String)this.host, (int)this.adminPortNumber);
        if (null != props) {
            this.password = props.getProperty("password");
        }
        if (this.password.equals("")) {
            this.password = (String)passwordForURI.get(this.uri + this.platformRoot);
            if (this.password == null) {
                this.password = "";
            }
        }
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.adminPortNumber;
    }

    public String getNonAdminPortNumber() {
        return this.nonAdminPortNumber;
    }

    public boolean isRestartNeeded() {
        boolean retVal;
        if (!this.secureStatusHasBeenChecked) {
            return false;
        }
        if (!this.goodUserNamePassword) {
            return false;
        }
        if (!this.isRunning()) {
            return false;
        }
        try {
            ServerInfo si = new ServerInfo(this.getMBeanServerConnection());
            retVal = si.isRestartRequired();
        }
        catch (RemoteException e) {
            retVal = false;
        }
        return retVal;
    }

    public void fixJVMDebugOptions() throws RemoteException {
        JvmOptions jvmInfo = new JvmOptions(this.getMBeanServerConnection());
        jvmInfo.getAddressValue();
        if (jvmInfo.isWindows() && !jvmInfo.isSharedMemory()) {
            jvmInfo.setDefaultTransportForDebug(this.getHost() + this.getPort());
        }
    }

    public String getDebugAddressValue() throws RemoteException {
        String retVal;
        block2: {
            retVal = this.lastAddress;
            JvmOptions jvmInfo = null;
            try {
                jvmInfo = new JvmOptions(this.getMBeanServerConnection());
                this.lastAddress = retVal = jvmInfo.getAddressValue();
            }
            catch (RemoteException re) {
                if (null != this.lastAddress) break block2;
                throw re;
            }
        }
        return retVal;
    }

    public boolean isDebugSharedMemory() throws RemoteException {
        boolean retVal = this.lastIsSharedMem;
        JvmOptions jvmInfo = null;
        try {
            jvmInfo = new JvmOptions(this.getMBeanServerConnection());
            this.lastIsSharedMem = retVal = jvmInfo.isSharedMemory();
        }
        catch (RemoteException re) {
            ErrorManager.getDefault().notify(1, (Throwable)re);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return retVal;
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        return new SunONEDeploymentConfiguration(dObj);
    }

    File getInternalPlanFile(InputStream plan) throws IllegalStateException {
        ZipOutputStream jar = null;
        try {
            File tmpFile = File.createTempFile("dplan", "tmp");
            jar = new JarOutputStream(new FileOutputStream(tmpFile));
            Util.convert((InputStream)plan, (JarOutputStream)jar);
            jar.close();
            jar = null;
            tmpFile.deleteOnExit();
            File file = tmpFile;
            return file;
        }
        catch (IOException ioe) {
            IllegalStateException ise = new IllegalStateException("file handling issues");
            ise.initCause(ioe);
            throw ise;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Throwable t) {
                    jsr88Logger.severe("bad one");
                }
            }
        }
    }

    public ProgressObject distribute(Target[] target, InputStream archive, InputStream plan) throws IllegalStateException {
        FileInputStream innerPlan = null;
        this.ThrowExceptionIfSuspended();
        ViewLogAction.viewLog(this);
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            File f = this.getInternalPlanFile(plan);
            innerPlan = new FileInputStream(f);
            Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
            ProgressObject retVal = this.innerDM.distribute(target, archive, (InputStream)innerPlan);
            retVal.addProgressListener((ProgressListener)new FileDeleter(f));
            ProgressObject progressObject = retVal;
            return progressObject;
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (IOException ioe) {
            IllegalStateException ise = new IllegalStateException("file handling issues");
            ise.initCause(ioe);
            throw ise;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
            if (null != innerPlan) {
                try {
                    ((InputStream)innerPlan).close();
                }
                catch (Throwable t) {
                    jsr88Logger.severe("bad two");
                }
            }
        }
    }

    public ProgressObject distribute(Target[] target, File archive, File plan) throws IllegalStateException {
        this.ThrowExceptionIfSuspended();
        File[] resourceDirs = Utils.getResourceDirs(archive);
        if (resourceDirs != null) {
            Utils.registerResources(resourceDirs, this.getManagement());
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
            ViewLogAction.viewLog(this);
            ProgressObject progressObject = this.innerDM.distribute(target, archive, null);
            return progressObject;
        }
        catch (Exception fnfe) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(fnfe);
            throw ise;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleType modType, Target[] target) throws TargetException, IllegalStateException {
        try {
            this.ThrowExceptionIfSuspended();
        }
        catch (RuntimeException re) {
            return new TargetModuleID[0];
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
        try {
            TargetModuleID[] tm;
            TargetModuleID[] targetModuleIDArray = tm = this.innerDM.getAvailableModules(modType, target);
            return targetModuleIDArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public Locale getCurrentLocale() {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.getCurrentLocale();
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.getDConfigBeanVersion();
    }

    public Locale getDefaultLocale() {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.getDefaultLocale();
    }

    public TargetModuleID[] getNonRunningModules(ModuleType mType, Target[] target) throws TargetException, IllegalStateException {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.getNonRunningModules(mType, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getRunningModules(ModuleType mType, Target[] target) throws TargetException, IllegalStateException {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
        try {
            TargetModuleID[] ttt;
            TargetModuleID[] targetModuleIDArray = ttt = this.innerDM.getRunningModules(mType, target);
            return targetModuleIDArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public Locale[] getSupportedLocales() {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.getSupportedLocales();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target[] getTargets() throws IllegalStateException {
        try {
            this.ThrowExceptionIfSuspended();
        }
        catch (Exception ex) {
            return new Target[0];
        }
        Target[] retVal = null;
        if (!this.secureStatusHasBeenChecked) {
            retVal = null;
        } else if (null == this.innerDM) {
            retVal = new Target[]{new FakeTarget()};
        } else {
            if (this.isLocal()) {
                try {
                    Object configDir = this.getManagement().invoke(new ObjectName("ias:type=domain,category=config"), "getConfigDir", null, null);
                    if (configDir == null) {
                        this.mmm = null;
                        return null;
                    }
                    String dir = configDir.toString();
                    File domainLocationAsReturnedByTheServer = new File(dir).getParentFile().getParentFile();
                    String l1 = domainLocationAsReturnedByTheServer.getCanonicalPath();
                    DeploymentManagerProperties dmProps = new DeploymentManagerProperties(this);
                    String domainDir = dmProps.getLocation();
                    if (!l1.equals(domainDir = new File(domainDir).getCanonicalPath())) {
                        return null;
                    }
                }
                catch (RemoteException ee) {
                    return null;
                }
                catch (Throwable ee) {
                    ErrorManager.getDefault().notify(1, ee);
                    return null;
                }
            }
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
                retVal = this.innerDM.getTargets();
            }
            catch (IllegalStateException ise) {
                retVal = new Target[]{};
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }
        return retVal;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType vers) {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.isDConfigBeanVersionSupported(vers);
    }

    public boolean isLocaleSupported(Locale locale) {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.isLocaleSupported(locale);
    }

    public boolean isRedeploySupported() {
        this.ThrowExceptionIfSuspended();
        return this.innerDM.isRedeploySupported();
    }

    public ProgressObject redeploy(TargetModuleID[] targetModuleID, InputStream archive, InputStream plan) throws UnsupportedOperationException, IllegalStateException {
        this.ThrowExceptionIfSuspended();
        InputStream innerPlan = null;
        ViewLogAction.viewLog(this);
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ProgressObject retVal;
            Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
            ProgressObject progressObject = retVal = this.innerDM.redeploy(targetModuleID, archive, innerPlan);
            return progressObject;
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
            throw ise;
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            IllegalStateException ise = new IllegalStateException("file handling issues");
            ise.initCause(ioe);
            throw ise;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
            if (null != innerPlan) {
                try {
                    innerPlan.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    jsr88Logger.severe("bad two");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleID, File archive, File plan) throws UnsupportedOperationException, IllegalStateException {
        this.ThrowExceptionIfSuspended();
        File[] resourceDirs = Utils.getResourceDirs(archive);
        if (resourceDirs != null) {
            Utils.registerResources(resourceDirs, this.getManagement());
        }
        ViewLogAction.viewLog(this);
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
        try {
            ProgressObject progressObject = this.innerDM.redeploy(targetModuleID, archive, null);
            return progressObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public void release() {
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType versionType) throws DConfigBeanVersionUnsupportedException {
        this.ThrowExceptionIfSuspended();
        this.innerDM.setDConfigBeanVersion(versionType);
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.ThrowExceptionIfSuspended();
        this.innerDM.setLocale(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject start(TargetModuleID[] targetModuleID) throws IllegalStateException {
        this.ThrowExceptionIfSuspended();
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
        try {
            TargetModuleID[] weeded = this.weedOutAppClientTMID(targetModuleID);
            ProgressObject retVal = null;
            retVal = weeded.length < 1 ? new ShortCircuitProgressObject(CommandType.START, NbBundle.getMessage(SunDeploymentManager.class, (String)"MESS_STARTED"), StateType.COMPLETED, targetModuleID) : this.innerDM.start(weeded);
            ProgressObject progressObject = retVal;
            return progressObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject stop(TargetModuleID[] targetModuleID) throws IllegalStateException {
        this.ThrowExceptionIfSuspended();
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
        try {
            TargetModuleID[] weeded = this.weedOutAppClientTMID(targetModuleID);
            ProgressObject retVal = null;
            retVal = weeded.length < 1 ? new ShortCircuitProgressObject(CommandType.STOP, NbBundle.getMessage(SunDeploymentManager.class, (String)"MESS_STOPPED"), StateType.COMPLETED, targetModuleID) : this.innerDM.stop(weeded);
            ProgressObject progressObject = retVal;
            return progressObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    private TargetModuleID[] weedOutAppClientTMID(TargetModuleID[] tmids) {
        ArrayList<TargetModuleID> retList = new ArrayList<TargetModuleID>();
        try {
            Class[] argClass = new Class[]{TargetModuleID.class};
            Object[] argObject = new Object[1];
            ClassLoader loader = this.getExtendedClassLoader();
            if (loader != null) {
                Class<?> cc = loader.loadClass("org.netbeans.modules.j2ee.sun.bridge.AppServerBridge");
                Method isCar = cc.getMethod("isCar", argClass);
                for (TargetModuleID tmid : tmids) {
                    argObject[0] = tmid;
                    boolean doNotAddToRetList = (Boolean)isCar.invoke(null, argObject);
                    if (doNotAddToRetList) continue;
                    retList.add(tmid);
                }
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return retList.toArray(new TargetModuleID[retList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject undeploy(TargetModuleID[] targetModuleID) throws IllegalStateException {
        this.ThrowExceptionIfSuspended();
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ServerLocationManager.getServerOnlyClassLoader((File)this.getPlatformRoot()));
        try {
            ProgressObject progressObject = this.innerDM.undeploy(targetModuleID);
            return progressObject;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    private void calculateIsLocal() {
        String domainDir;
        boolean isset = false;
        InstanceProperties ip = SunURIManager.getInstanceProperties((File)this.getPlatformRoot(), (String)this.getHost(), (int)this.getPort());
        if (ip != null && "".equals(domainDir = ip.getProperty("LOCATION"))) {
            this.isLocal = false;
            isset = true;
        }
        if (!isset) {
            if (this.getHost().equals("localhost")) {
                this.isLocal = true;
            }
            try {
                new Thread(){

                    public void run() {
                        try {
                            String ia = InetAddress.getByName(SunDeploymentManager.this.getHost()).getHostAddress();
                            if (ia.equals("127.0.0.1")) {
                                SunDeploymentManager.this.isLocal = true;
                            } else {
                                String currentCanonName;
                                String localCanonName = InetAddress.getLocalHost().getCanonicalHostName();
                                SunDeploymentManager.this.isLocal = localCanonName.equals(currentCanonName = InetAddress.getByName(SunDeploymentManager.this.getHost()).getCanonicalHostName());
                            }
                        }
                        catch (Exception e) {
                            Constants.jsr88Logger.severe(e.getMessage());
                        }
                    }
                }.start();
            }
            finally {
                return;
            }
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public synchronized boolean isRunning() {
        return this.isRunning(false);
    }

    public boolean isRunning(boolean forced) {
        boolean retVal = false;
        if (this.isSuspended()) {
            retVal = true;
        } else {
            long current = System.currentTimeMillis();
            if (!forced && current - this.timeStampCheckingRunning < 4000L) {
                retVal = this.runningState;
            } else {
                Object t;
                boolean newrunningState = false;
                this.timeStampCheckingRunning = current;
                try {
                    if (this.secureStatusHasBeenChecked && this.maybeRunningButWrongUserName) {
                        this.testCredentials();
                    }
                    this.ThrowExceptionIfSuspended();
                    t = this.getTargets();
                    if (t != null) {
                        newrunningState = ((Target[])t).length != 0;
                    }
                }
                catch (Throwable e) {
                    newrunningState = false;
                }
                this.runningState = newrunningState;
                if (this.runningState && this.nonAdminPortNumber == null) {
                    try {
                        this.nonAdminPortNumber = (String)this.getManagement().getAttribute(new ObjectName("com.sun.appserv:type=http-listener,id=http-listener-1,config=server-config,category=config"), "port");
                        t = new Runnable(){

                            public void run() {
                                try {
                                    SunDeploymentManager.this.storeAntDeploymentProperties(SunDeploymentManager.this.getAntDeploymentPropertiesFile(), true);
                                }
                                catch (IOException ioe) {
                                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                                }
                            }
                        };
                        RequestProcessor.getDefault().post((Runnable)t);
                    }
                    catch (Throwable ee) {
                        ee.printStackTrace();
                    }
                }
                this.timeStampCheckingRunning = System.currentTimeMillis();
                retVal = this.runningState;
            }
        }
        return retVal;
    }

    public void ThrowExceptionIfSuspended() {
        if (!this.secureStatusHasBeenChecked) {
            this.mmm = null;
            try {
                this.secure = this.isGlassFish ? PortDetector.isSecurePortGlassFish((String)this.getHost(), (int)this.getPort()) : PortDetector.isSecurePort((String)this.getHost(), (int)this.getPort());
                if (this.secure) {
                    if (!this.uri.endsWith(SECURESTRINGDETECTION)) {
                        this.uri = this.uri + SECURESTRINGDETECTION;
                    }
                    this.resetInnerDeploymentManager();
                }
                this.secureStatusHasBeenChecked = true;
                this.testCredentials();
            }
            catch (Exception e) {
                this.secureStatusHasBeenChecked = false;
            }
        }
        if (this.isSuspended()) {
            throw new RuntimeException(bundle.getString("MSG_ServerInDebug"));
        }
        if (this.secureStatusHasBeenChecked && !this.goodUserNamePassword) {
            throw new RuntimeException(bundle.getString("MSG_WRONG_UserPassword"));
        }
    }

    public boolean isSuspended() {
        return StartSunServer.isSuspended(this);
    }

    public ServerInterface getManagement() {
        if (this.mmm == null) {
            try {
                Class[] argClass = new Class[]{DeploymentManager.class};
                Object[] argObject = new Object[]{this};
                ClassLoader loader = this.getExtendedClassLoader();
                if (loader != null) {
                    Class<?> cc = loader.loadClass("org.netbeans.modules.j2ee.sun.share.management.ServerMEJB");
                    this.mmm = (ServerInterface)cc.newInstance();
                    this.mmm.setDeploymentManager((DeploymentManager)this);
                }
            }
            catch (Exception ex) {
                this.mmm = null;
                ex.printStackTrace();
            }
        }
        return this.mmm;
    }

    public void testCredentials() {
        Authenticator.setDefault((Authenticator)new AdminAuthenticator((SunDeploymentManagerInterface)this));
        this.goodUserNamePassword = false;
        this.maybeRunningButWrongUserName = false;
        try {
            Class[] argClass = new Class[]{DeploymentManager.class};
            Object[] argObject = new Object[]{this};
            ClassLoader loader = this.getExtendedClassLoader();
            if (loader != null) {
                Class<?> cc = loader.loadClass("org.netbeans.modules.j2ee.sun.share.management.ServerMEJB");
                ServerInterface si = (ServerInterface)cc.newInstance();
                si.setDeploymentManager((DeploymentManager)this);
                si.checkCredentials();
                this.goodUserNamePassword = true;
            }
        }
        catch (ClassNotFoundException ex) {
            this.goodUserNamePassword = false;
        }
        catch (InstantiationException ex) {
            this.goodUserNamePassword = false;
        }
        catch (IllegalAccessException ex) {
            this.goodUserNamePassword = false;
        }
        catch (IOException e) {
            if (!e.getMessage().contains("500")) {
                this.maybeRunningButWrongUserName = true;
            }
            String serverTitle = this.getInstanceDisplayName();
            DialogDescriptor desc = new DialogDescriptor((Object)NbBundle.getMessage(SunDeploymentManager.class, (String)"ERR_AUTH_DIALOG_MSG", (Object[])new Object[]{serverTitle != null ? serverTitle : NbBundle.getMessage(SunDeploymentManager.class, (String)"WORD_SERVER"), e.getLocalizedMessage()}), NbBundle.getMessage(SunDeploymentManager.class, (String)"ERR_AUTH_DIALOG_TITLE"));
            desc.setModal(false);
            desc.setMessageType(0);
            desc.setOptions(new Object[]{DialogDescriptor.OK_OPTION});
            desc.setOptionsAlign(0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    private String getInstanceDisplayName() {
        InstanceProperties ip = SunURIManager.getInstanceProperties((File)this.getPlatformRoot(), (String)this.getHost(), (int)this.getPort());
        return ip != null ? ip.getProperty("displayName") : null;
    }

    public ResourceConfiguratorInterface getResourceConfigurator() {
        if (this.resourceConfigurator == null) {
            ResourceConfigurator r = new ResourceConfigurator();
            r.setDeploymentManager((DeploymentManager)this);
            this.resourceConfigurator = r;
        }
        return this.resourceConfigurator;
    }

    private MBeanServerConnection getMBeanServerConnection() throws RemoteException, ServerException {
        ServerInterface serverMgmt = this.getManagement();
        return serverMgmt.getMBeanServerConnection();
    }

    public boolean isMaybeRunningButWrongUserName() {
        return this.maybeRunningButWrongUserName;
    }

    public boolean isSecure() {
        return this.secure;
    }

    static String getHostFromURI(String uri) {
        String retVal = null;
        try {
            int len1 = uri.lastIndexOf(58);
            String partial = uri.substring(0, len1);
            int len2 = partial.lastIndexOf(58);
            retVal = uri.substring(len2 + 1, len1);
        }
        catch (Throwable t) {
            jsr88Logger.warning("getHostFromURI:: invalid uri: " + uri);
        }
        return retVal;
    }

    static int getPortFromURI(String uri) {
        int retVal = -1;
        int len1 = uri.lastIndexOf(58);
        if (-1 != len1) {
            try {
                retVal = Integer.parseInt(uri.substring(len1 + 1));
            }
            catch (NumberFormatException nfe) {
                jsr88Logger.warning(nfe.getMessage());
            }
        }
        return retVal;
    }

    public void refreshDeploymentManager() {
        try {
            this.resetInnerDeploymentManager();
        }
        catch (Exception ex) {
            return;
        }
    }

    public File getPlatformRoot() {
        return this.platformRoot;
    }

    private ClassLoader getExtendedClassLoader() {
        return ServerLocationManager.getNetBeansAndServerClassLoader((File)this.getPlatformRoot());
    }

    public void setUserName(String name) {
        this.mmm = null;
        this.secureStatusHasBeenChecked = false;
        String oldValue = this.userName;
        this.userName = name;
        this.propertySupport.firePropertyChange("name", oldValue, this.userName);
    }

    public void setPassword(String pw) {
        this.mmm = null;
        this.secureStatusHasBeenChecked = false;
        String oldValue = this.password;
        this.password = pw;
        passwordForURI.put(this.uri + this.platformRoot, this.password);
        this.refreshDeploymentManager();
        this.propertySupport.firePropertyChange("password", oldValue, this.password);
    }

    public File getAntDeploymentPropertiesFile() {
        return new File(System.getProperty("netbeans.user"), this.getInstanceID() + ".properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAntDeploymentProperties(File file, boolean create) throws IOException {
        if (!create && !file.exists()) {
            return;
        }
        Properties antProps = new Properties();
        antProps.setProperty("sjsas.root", this.getPlatformRoot().getAbsolutePath());
        antProps.setProperty("sjsas.url", this.getWebUrl());
        antProps.setProperty("sjsas.username", this.getUserName());
        antProps.setProperty("sjsas.password", this.getPassword());
        antProps.setProperty("sjsas.host", this.getHost());
        antProps.setProperty("sjsas.port", this.getPort() + "");
        file.createNewFile();
        FileObject fo = FileUtil.toFileObject((File)file);
        FileLock lock = null;
        try {
            lock = fo.lock();
            OutputStream os = fo.getOutputStream(lock);
            try {
                antProps.store(os, "");
            }
            finally {
                if (null != os) {
                    os.close();
                }
            }
        }
        finally {
            if (null != lock) {
                lock.releaseLock();
            }
        }
    }

    String getInstanceID() {
        InstanceProperties ip = SunURIManager.getInstanceProperties((File)this.platformRoot, (String)this.host, (int)this.adminPortNumber);
        String name = null;
        if (null != ip) {
            name = ip.getProperty(PROP_INSTANCE_ID);
        }
        if (name == null) {
            boolean isGF = ServerLocationManager.isGlassFish((File)this.platformRoot);
            String prefix = isGF ? "glassfish" : "sjsas8";
            String[] instanceURLs = Deployment.getDefault().getInstancesOfServer("J2EE");
            int len = 0;
            if (null != instanceURLs) {
                len = instanceURLs.length;
            }
            int i = 0;
            while (name == null) {
                name = i == 0 ? prefix : prefix + "_" + i;
                for (int j = 0; j < len; ++j) {
                    String anotherName;
                    InstanceProperties iip;
                    String url = instanceURLs[j];
                    String uri = null;
                    if (null != ip) {
                        uri = ip.getProperty("url");
                    }
                    if (url.equals(uri) || (iip = InstanceProperties.getInstanceProperties((String)url)) == null || !name.equals(anotherName = iip.getProperty(PROP_INSTANCE_ID))) continue;
                    name = null;
                    break;
                }
                ++i;
            }
            if (null != ip) {
                ip.setProperty(PROP_INSTANCE_ID, name);
            }
        }
        return name;
    }

    private String getWebUrl() {
        return "http://" + this.host + ":" + this.nonAdminPortNumber;
    }

    public HashMap getSunDatasourcesFromXml() {
        DomainEditor dEditor = new DomainEditor(this);
        return dEditor.getSunDatasourcesFromXml();
    }

    public HashMap getConnPoolsFromXml() {
        DomainEditor dEditor = new DomainEditor(this);
        return dEditor.getConnPoolsFromXml();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    static class ShortCircuitProgressObject
    implements ProgressObject {
        private CommandType ct;
        private String message;
        private StateType st;
        private TargetModuleID[] tmids;
        ProgressEventSupport pes = new ProgressEventSupport(this);

        ShortCircuitProgressObject(CommandType ct, String message, StateType st, TargetModuleID[] tmids) {
            this.ct = ct;
            this.message = message;
            this.st = st;
            this.tmids = tmids;
        }

        public DeploymentStatus getDeploymentStatus() {
            return new DeploymentStatus(){

                public ActionType getAction() {
                    return ActionType.EXECUTE;
                }

                public CommandType getCommand() {
                    return ShortCircuitProgressObject.this.ct;
                }

                public String getMessage() {
                    return ShortCircuitProgressObject.this.message;
                }

                public StateType getState() {
                    return ShortCircuitProgressObject.this.st;
                }

                public boolean isCompleted() {
                    return ShortCircuitProgressObject.this.st.equals(StateType.COMPLETED);
                }

                public boolean isFailed() {
                    return ShortCircuitProgressObject.this.st.equals(StateType.FAILED);
                }

                public boolean isRunning() {
                    return ShortCircuitProgressObject.this.st.equals(StateType.RUNNING);
                }
            };
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return this.tmids;
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.pes.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.pes.removeProgressListener(progressListener);
        }
    }

    class FileDeleter
    implements ProgressListener {
        File f;

        public FileDeleter(File f) {
            this.f = f;
        }

        public void handleProgressEvent(ProgressEvent pe) {
            DeploymentStatus ds = pe.getDeploymentStatus();
            if (ds.isCompleted() || ds.isFailed()) {
                this.f.delete();
            }
        }
    }

    class FakeTarget
    implements Target {
        FakeTarget() {
        }

        public String getDescription() {
            return "fakeTargetDescr";
        }

        public String getName() {
            return "fakeTargetName";
        }
    }
}

