/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class AddInstanceVisualDirectoryPanel
extends JPanel {
    private boolean createPersonalInstance;
    private final Set listeners = new HashSet(1);
    private JTextField adminPortDisplay;
    private JLabel adminPortLabel;
    private JLabel description;
    private JLabel detectedLabel;
    private JTextField instanceDirectory;
    private JLabel instanceDirectoryLabel;
    private JButton openInstanceDirectorySelector;
    private JLabel spaceHack;

    public AddInstanceVisualDirectoryPanel(boolean createPersonalInstance) {
        this.initComponents();
        this.setAdminPort("");
        this.createPersonalInstance = createPersonalInstance;
        if (createPersonalInstance) {
            this.description.setText(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"TXT_instanceDirectoryDescription2"));
        }
        this.adminPortLabel.setVisible(!createPersonalInstance);
        this.adminPortDisplay.setVisible(!createPersonalInstance);
        this.instanceDirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                AddInstanceVisualDirectoryPanel.this.locationChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                AddInstanceVisualDirectoryPanel.this.locationChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                AddInstanceVisualDirectoryPanel.this.locationChanged();
            }
        });
    }

    public String getName() {
        return NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"StepName_EnterDomainDirectory");
    }

    void setAdminPort(String uri) {
        if (!this.createPersonalInstance) {
            this.adminPortDisplay.setText(uri);
            this.detectedLabel.setVisible(uri.length() > 0);
        }
    }

    String getInstanceDirectory() {
        return this.instanceDirectory.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    void locationChanged() {
        this.fireChangeEvent();
    }

    private String browseDomainLocation() {
        String insLocation = null;
        JFileChooser chooser = null;
        chooser = this.createPersonalInstance ? new JFileChooser() : new DomainChooser();
        Util.decorateChooser(chooser, this.instanceDirectory.getText(), NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_Choose_Domain"));
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_Choose_Button"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    private void initComponents() {
        this.description = new JLabel();
        this.instanceDirectoryLabel = new JLabel();
        this.instanceDirectory = new JTextField();
        this.openInstanceDirectorySelector = new JButton();
        this.adminPortLabel = new JLabel();
        this.adminPortDisplay = new JTextField();
        this.detectedLabel = new JLabel();
        this.spaceHack = new JLabel();
        this.setLayout(new GridBagLayout());
        this.description.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("TXT_instanceDirectoryDescription1"));
        this.description.setEnabled(false);
        this.description.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.description, gridBagConstraints);
        this.instanceDirectoryLabel.setDisplayedMnemonic(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"MNM_instanceDirectoryLabel").charAt(0));
        this.instanceDirectoryLabel.setLabelFor(this.instanceDirectory);
        this.instanceDirectoryLabel.setText(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_instanceDirectoryLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 6, 6);
        this.add((Component)this.instanceDirectoryLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 6, 6, 6);
        this.add((Component)this.instanceDirectory, gridBagConstraints);
        this.instanceDirectory.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_instanceDirectory"));
        this.openInstanceDirectorySelector.setMnemonic(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"MNM_openInstanceDirectorySelector").charAt(0));
        this.openInstanceDirectorySelector.setText(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_openInstanceDirectorySelector"));
        this.openInstanceDirectorySelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddInstanceVisualDirectoryPanel.this.openInstanceDirectorySelectorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 6, 6, 0);
        this.add((Component)this.openInstanceDirectorySelector, gridBagConstraints);
        this.openInstanceDirectorySelector.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("DSC_openInstanceDirectorySelector"));
        this.adminPortLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("MNM_adminPortLabel").charAt(0));
        this.adminPortLabel.setLabelFor(this.adminPortDisplay);
        this.adminPortLabel.setText(NbBundle.getMessage(AddInstanceVisualDirectoryPanel.class, (String)"LBL_adminlPortLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this.adminPortLabel, gridBagConstraints);
        this.adminPortDisplay.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 6);
        this.add((Component)this.adminPortDisplay, gridBagConstraints);
        this.detectedLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/j2ee/ui/Bundle").getString("LBL_detectedLabel"));
        this.detectedLabel.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 6);
        this.add((Component)this.detectedLabel, gridBagConstraints);
        this.spaceHack.setEnabled(false);
        this.spaceHack.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spaceHack, gridBagConstraints);
    }

    private void openInstanceDirectorySelectorActionPerformed(ActionEvent evt) {
        String val = this.browseDomainLocation();
        if (null != val && val.length() >= 1) {
            this.instanceDirectory.setText(val);
        }
    }

    private class DomainChooser
    extends JFileChooser {
        private DomainChooser() {
        }

        public void approveSelection() {
            File dir = FileUtil.normalizeFile((File)this.getSelectedFile());
            if (Util.rootOfUsableDomain(dir)) {
                super.approveSelection();
            } else {
                this.setCurrentDirectory(dir);
            }
        }
    }
}

