/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.UserCancelException;

public class ResourcePanel
extends JPanel {
    public static final String PROP_RESOURCE = "property_resource";
    private I18nString i18nString;
    private Project project;
    private FileObject file;
    private JButton browseButton;
    private JPanel jPanel1;
    private JButton newButton;
    private JLabel resourceLabel;
    private JTextField resourceText;

    public ResourcePanel(Project project, FileObject file) {
        this.project = project;
        this.file = file;
        this.initComponents();
        this.initAccessibility();
        this.enableComponents();
    }

    public void setFile(FileObject fo) {
        this.file = fo;
    }

    public FileObject getFile() {
        return this.file;
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateValues();
    }

    public void setProject(Project project) {
        if (this.project != project) {
            this.project = project;
            this.resourceText.setText("");
        }
        this.enableComponents();
    }

    public Project getProject() {
        return this.project;
    }

    private void updateValues() {
        this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
    }

    private void changeResource(DataObject resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        DataObject oldValue = this.i18nString.getSupport().getResourceHolder().getResource();
        if (oldValue != null && oldValue.equals(resource)) {
            return;
        }
        this.i18nString.getSupport().getResourceHolder().setResource(resource);
        String newResourceValue = this.i18nString.getSupport().getResourceHolder().getValueForKey(this.i18nString.getKey());
        if (newResourceValue != null) {
            this.i18nString.setValue(newResourceValue);
        }
        this.updateValues();
        this.firePropertyChange(PROP_RESOURCE, oldValue, resource);
        I18nUtil.getOptions().setLastResource2(resource);
    }

    private void resourceTextActionPerformedDelegate(ActionEvent evt) {
        DataObject resource = this.findResource(this.resourceText.getText());
        if (resource != null) {
            this.changeResource(resource);
        } else {
            this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
        }
    }

    private DataObject findResource(String bundleName) {
        try {
            bundleName = bundleName.replace('.', '/');
            String resourceName = bundleName + ".properties";
            FileObject fileObject = Util.getResource(this.file, resourceName);
            if (fileObject == null) {
                return null;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (this.isResourceClass(dataObject.getClass())) {
                return dataObject;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isResourceClass(Class clazz) {
        return Arrays.asList(this.i18nString.getSupport().getResourceHolder().getResourceClasses()).contains(clazz);
    }

    private String getResourceName(DataObject resource) {
        if (resource == null) {
            return "";
        }
        String name = Util.getResourceName(this.file, resource.getPrimaryFile(), '.', false);
        if (name != null) {
            return name;
        }
        return "";
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourcePanel"));
        this.newButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_NewButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_BrowseButton"));
        this.resourceText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourceText"));
    }

    private void initComponents() {
        this.resourceLabel = new JLabel();
        this.resourceText = new JTextField();
        this.jPanel1 = new JPanel();
        this.browseButton = new JButton();
        this.newButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.resourceLabel.setText(I18nUtil.getBundle().getString("LBL_BundleName"));
        this.resourceLabel.setLabelFor(this.resourceText);
        this.resourceLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_BundleName_Mnem").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.resourceLabel, gridBagConstraints);
        this.resourceText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourcePanel.this.resourceTextActionPerformed(evt);
            }
        });
        this.resourceText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ResourcePanel.this.resourceTextFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.resourceText, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(1, 2, 5, 0));
        this.browseButton.setMnemonic(I18nUtil.getBundle().getString("CTL_BrowseButton_Mnem").charAt(0));
        this.browseButton.setText(I18nUtil.getBundle().getString("CTL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourcePanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.browseButton);
        this.newButton.setMnemonic(I18nUtil.getBundle().getString("CTL_NewButton_Mnem").charAt(0));
        this.newButton.setText(I18nUtil.getBundle().getString("CTL_NewButton"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourcePanel.this.newButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.newButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 0, 11, 11);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        try {
            DataObject template = this.i18nString.getSupport().getResourceHolder().getTemplate(this.i18nString.getSupport().getResourceHolder().getResourceClasses()[0]);
            DataObject resource = SelectorUtils.instantiateTemplate(this.project, this.file, template);
            if (resource != null) {
                this.changeResource(resource);
            }
        }
        catch (UserCancelException uce) {
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        DataObject resource = SelectorUtils.selectBundle(this.project, this.file);
        if (resource != null) {
            this.changeResource(resource);
        }
    }

    private void resourceTextFocusLost(FocusEvent evt) {
        this.resourceTextActionPerformedDelegate(new ActionEvent(evt.getSource(), evt.getID(), null));
    }

    private void resourceTextActionPerformed(ActionEvent evt) {
        this.resourceTextActionPerformedDelegate(evt);
    }

    public void setResource(DataObject resource) {
        if (this.isResourceClass(resource.getClass())) {
            this.changeResource(resource);
        }
    }

    private void enableComponents() {
        boolean enabled = this.project != null;
        this.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
        this.newButton.setEnabled(enabled);
        this.resourceText.setEnabled(enabled);
        this.resourceLabel.setEnabled(enabled);
    }
}

