/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.api.ejbjar;

import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.ejbjar.EarAccessor;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class Ear {
    private final EarImplementation impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(EarProvider.class));

    private Ear(EarImplementation impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static Ear getEar(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to Ear.getEar(FileObject)");
        }
        for (EarProvider impl : implementations.allInstances()) {
            Ear wm = impl.findEar(f);
            if (wm == null) continue;
            return wm;
        }
        return null;
    }

    public String getJ2eePlatformVersion() {
        return this.impl.getJ2eePlatformVersion();
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public void addWebModule(WebModule module) {
        this.impl.addWebModule(module);
    }

    public void addEjbJarModule(EjbJar module) {
        this.impl.addEjbJarModule(module);
    }

    public void addCarModule(Car module) {
        this.impl.addCarModule(module);
    }

    static {
        EarAccessor.DEFAULT = new EarAccessor(){

            public Ear createEar(EarImplementation spiEar) {
                return new Ear(spiEar);
            }

            public EarImplementation getEarImplementation(Ear wm) {
                return wm == null ? null : wm.impl;
            }
        };
    }
}

