/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractTreeDTD;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.Util;
import org.netbeans.tax.spec.ConditionalSection;
import org.netbeans.tax.spec.DTD;
import org.netbeans.tax.spec.ParameterEntityReference;

public class TreeConditionalSection
extends AbstractTreeDTD
implements DTD.Child,
ParameterEntityReference.Child,
ConditionalSection.Child {
    public static final String PROP_INCLUDE = "include";
    public static final String PROP_IGNORED_CONTENT = "ignoredContent";
    public static final boolean IGNORE = false;
    public static final boolean INCLUDE = true;
    private boolean include;
    private String ignoredContent;

    public TreeConditionalSection(boolean include) {
        this.include = include;
        this.ignoredContent = new String();
    }

    protected TreeConditionalSection(TreeConditionalSection conditionalSection, boolean deep) {
        super(conditionalSection, deep);
        this.include = conditionalSection.include;
        this.ignoredContent = conditionalSection.ignoredContent;
    }

    public Object clone(boolean deep) {
        return new TreeConditionalSection(this, deep);
    }

    public boolean equals(Object object, boolean deep) {
        if (!super.equals(object, deep)) {
            return false;
        }
        TreeConditionalSection peer = (TreeConditionalSection)object;
        if (this.include != peer.include) {
            return false;
        }
        return Util.equals(this.getIgnoredContent(), peer.getIgnoredContent());
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        super.merge(treeObject);
        TreeConditionalSection peer = (TreeConditionalSection)treeObject;
        this.setIncludeImpl(peer.isInclude());
        this.setIgnoredContentImpl(peer.getIgnoredContent());
    }

    public final boolean isInclude() {
        return this.include;
    }

    private final void setIncludeImpl(boolean newInclude) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeConditionalSection::setIncludeImpl: oldInclude = " + this.include);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                      ::setIncludeImpl: newInclude = " + newInclude);
        }
        boolean oldInclude = this.include;
        this.include = newInclude;
        this.firePropertyChange(PROP_INCLUDE, oldInclude ? Boolean.TRUE : Boolean.FALSE, newInclude ? Boolean.TRUE : Boolean.FALSE);
    }

    public final void setInclude(boolean newInclude) throws ReadOnlyException, InvalidArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeConditionalSection::setInclude: oldInclude = " + this.include);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("                      ::setInclude: newInclude = " + newInclude);
        }
        if (this.include == newInclude) {
            return;
        }
        this.checkReadOnly();
        this.setIncludeImpl(newInclude);
    }

    public final String getIgnoredContent() {
        return this.ignoredContent;
    }

    private void setIgnoredContentImpl(String newContent) {
        String oldContent = this.ignoredContent;
        this.ignoredContent = newContent;
        this.firePropertyChange(PROP_IGNORED_CONTENT, oldContent, newContent);
    }

    public final void setIgnoredContent(String newIgnoredContent) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.ignoredContent, newIgnoredContent)) {
            return;
        }
        this.checkReadOnly();
        this.setIgnoredContentImpl(newIgnoredContent);
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected class ChildListContentManager
    extends AbstractTreeDTD.ChildListContentManager {
        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeConditionalSection.this;
        }

        public void checkAssignableObject(Object obj) {
            super.checkAssignableObject(obj);
            this.checkAssignableClass(ConditionalSection.Child.class, obj);
        }
    }
}

