/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModel;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModelFactory;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.GlobalBindings;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;

public final class Utilities {
    private Utilities() {
    }

    public static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public static boolean isJavaIdentifier(String id) {
        boolean result = true;
        if (id == null || id.length() == 0 || !Character.isJavaIdentifierStart(id.charAt(0))) {
            result = false;
        } else {
            int idlength = id.length();
            for (int i = 1; i < idlength; ++i) {
                if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean isJavaPackage(String pkg) {
        boolean result = false;
        if (pkg != null && pkg.length() > 0) {
            int state = 0;
            int pkglength = pkg.length();
            block4: for (int i = 0; i < pkglength && state < 2; ++i) {
                switch (state) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(pkg.charAt(i))) {
                            state = 1;
                            continue block4;
                        }
                        state = 2;
                        continue block4;
                    }
                    case 1: {
                        if (pkg.charAt(i) == '.') {
                            state = 0;
                            continue block4;
                        }
                        if (Character.isJavaIdentifierPart(pkg.charAt(i))) continue block4;
                        state = 2;
                    }
                }
            }
            if (state == 1) {
                result = true;
            }
        }
        return result;
    }

    public static File getCanonicalFile(File f) {
        File f1;
        try {
            f1 = f.getCanonicalFile();
        }
        catch (IOException e) {
            f1 = null;
        }
        return f1;
    }

    public static String removeSpacesFromServiceName(String serviceName) {
        if (serviceName != null) {
            String result = "";
            if (serviceName.indexOf(" ") > -1) {
                StringTokenizer serviceNameTokenizer = new StringTokenizer(serviceName, " ", false);
                while (serviceNameTokenizer.hasMoreTokens()) {
                    StringBuffer token = new StringBuffer(serviceNameTokenizer.nextToken());
                    if (token == null) continue;
                    token.setCharAt(0, Character.toUpperCase(token.charAt(0)));
                    result = result.concat(token.toString());
                }
                return result;
            }
            if (serviceName.length() > 0) {
                result = Character.toUpperCase(serviceName.charAt(0)) + serviceName.substring(1);
            }
            StringBuffer buf = new StringBuffer(result);
            for (int i = 0; i < buf.length(); ++i) {
                if (Character.isDigit(buf.charAt(i)) && i + 1 < buf.length() && !Character.isDigit(buf.charAt(i + 1))) {
                    buf.setCharAt(i + 1, Character.toUpperCase(buf.charAt(i + 1)));
                    ++i;
                }
                result = buf.toString();
            }
            return result;
        }
        return null;
    }

    public static boolean addRelativeWsdlLocation(FileObject bindingFile, String relativePath) {
        BindingsModel bindingsModel;
        GlobalBindings gb = null;
        ModelSource ms = org.netbeans.modules.xml.retriever.catalog.Utilities.getModelSource((FileObject)bindingFile, (boolean)true);
        if (ms != null && (bindingsModel = BindingsModelFactory.getDefault().getModel(ms)) != null && (gb = bindingsModel.getGlobalBindings()) != null) {
            bindingsModel.startTransaction();
            gb.setWsdlLocation(relativePath);
            bindingsModel.endTransaction();
            return true;
        }
        return false;
    }
}

