/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.netbeans.modules.websvc.core.WebServiceTransferable;
import org.netbeans.modules.websvc.core.jaxws.actions.AddOperationAction;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.websvc.core.jaxws.actions.WsTesterPageAction;
import org.netbeans.modules.websvc.core.jaxws.nodes.HandlerButtonListener;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.RefreshWsDialog;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerAction;
import org.netbeans.modules.websvc.core.webservices.action.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.websvc.jaxws.api.JaxWsTesterCookie;
import org.netbeans.modules.websvc.jaxws.api.JaxWsWsdlCookie;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JaxWsNode
extends AbstractNode
implements OpenCookie,
JaxWsWsdlCookie,
JaxWsTesterCookie,
JaxWsRefreshCookie,
ConfigureHandlerCookie {
    Service service;
    FileObject srcRoot;
    JaxWsModel jaxWsModel;
    JavaClass implBeanClass;
    InstanceContent content;
    Project project;
    private static final Image WAITING_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/waiting.png");
    private static final Image ERROR_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/error-badge.gif");
    private static final Image SERVICE_BADGE = Utilities.loadImage((String)"org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.gif");

    public JaxWsNode(JaxWsModel jaxWsModel, Service service, FileObject srcRoot) {
        this(jaxWsModel, service, srcRoot, new InstanceContent());
    }

    private JaxWsNode(JaxWsModel jaxWsModel, Service service, FileObject srcRoot, InstanceContent content) {
        super((Children)new JaxWsChildren(service, srcRoot), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.jaxWsModel = jaxWsModel;
        this.service = service;
        this.srcRoot = srcRoot;
        this.content = content;
        this.setName(service.getName());
        content.add((Object)this);
        content.add((Object)service);
        content.add((Object)srcRoot);
        this.addImplClassToContent(content);
        this.project = FileOwnerQuery.getOwner((FileObject)srcRoot);
    }

    public Node.Cookie getCookie(Class type) {
        if (type == EditWSAttributesCookie.class) {
            return new EditWSAttributesCookieImpl((Node)this, this.jaxWsModel);
        }
        return super.getCookie(type);
    }

    public String getDisplayName() {
        if (this.service.getWsdlUrl() != null) {
            return NbBundle.getMessage(JaxWsNode.class, (String)"LBL_serviceNodeName", (Object)this.service.getServiceName(), (Object)this.service.getPortName());
        }
        return this.service.getName();
    }

    public String getShortDescription() {
        return this.getWsdlURL();
    }

    public Image getIcon(int type) {
        WsdlModeler wsdlModeler = ((JaxWsChildren)this.getChildren()).getWsdlModeler();
        if (wsdlModeler == null) {
            return SERVICE_BADGE;
        }
        if (wsdlModeler.getCreationException() == null) {
            if (((JaxWsChildren)this.getChildren()).isModelGenerationFinished()) {
                return SERVICE_BADGE;
            }
            return Utilities.mergeImages((Image)SERVICE_BADGE, (Image)WAITING_BADGE, (int)15, (int)8);
        }
        Image dirtyNodeImage = Utilities.mergeImages((Image)SERVICE_BADGE, (Image)ERROR_BADGE, (int)6, (int)6);
        if (((JaxWsChildren)this.getChildren()).isModelGenerationFinished()) {
            return dirtyNodeImage;
        }
        return Utilities.mergeImages((Image)dirtyNodeImage, (Image)WAITING_BADGE, (int)15, (int)8);
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public void open() {
        OpenCookie oc = this.getOpenCookie();
        if (oc != null) {
            oc.open();
        }
    }

    private OpenCookie getOpenCookie() {
        FileObject f;
        OpenCookie oc = null;
        JavaClass ce = this.getImplBeanClass();
        if (ce != null && (f = JavaModel.getFileObject((Resource)ce.getResource())) != null) {
            try {
                DataObject d = DataObject.find((FileObject)f);
                oc = (OpenCookie)d.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException de) {
                ErrorManager.getDefault().log(1, de.toString());
            }
        }
        return oc;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(JaxWsRefreshAction.class), null, SystemAction.get(AddOperationAction.class), null, SystemAction.get(WsTesterPageAction.class), null, SystemAction.get(WSEditAttributesAction.class), null, SystemAction.get(ConfigureHandlerAction.class), null, SystemAction.get(DeleteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    public String getWebServiceURL() {
        J2eeModuleProvider.ConfigSupport configSupport;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = provider.getInstanceProperties();
        if (instanceProperties == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_MissingServer"), 0));
            return "";
        }
        String portNumber = instanceProperties.getProperty("httpportnumber");
        if (portNumber == null || portNumber.equals("")) {
            portNumber = "8080";
        }
        String serverUrl = instanceProperties.getProperty("url");
        String hostName = "localhost";
        if (serverUrl != null && serverUrl.indexOf("::") > 0) {
            int index1 = serverUrl.indexOf("::");
            int index2 = serverUrl.lastIndexOf(":");
            if (index2 > index1 + 2) {
                hostName = serverUrl.substring(index1 + 2, index2);
            }
        }
        String contextRoot = null;
        Object moduleType = provider.getJ2eeModule().getModuleType();
        String wsURI = null;
        if (this.isJsr109Supported(this.project) && Util.isJavaEE5orHigher((Project)this.project)) {
            try {
                wsURI = this.getServiceUri(moduleType);
            }
            catch (UnsupportedEncodingException ex) {}
        } else {
            try {
                wsURI = this.getNonJsr109Uri(moduleType);
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
        }
        if (J2eeModule.WAR.equals(moduleType) && (contextRoot = (configSupport = provider.getConfigSupport()).getWebContextRoot()) != null && contextRoot.startsWith("/")) {
            contextRoot = contextRoot.substring(1);
        }
        return "http://" + hostName + ":" + portNumber + "/" + (contextRoot != null && !contextRoot.equals("") ? contextRoot + "/" : "") + wsURI;
    }

    private String getNonJsr109Uri(Object moduleType) throws UnsupportedEncodingException {
        FileObject sunJaxwsFo;
        WebModule webModule;
        FileObject webInfFo;
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (J2eeModule.WAR.equals(moduleType) && (webInfFo = (webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory())).getWebInf()) != null && (sunJaxwsFo = webInfFo.getFileObject("sun-jaxws", "xml")) != null) {
            try {
                String urlPattern;
                Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunJaxwsFo);
                if (endpoints != null && (urlPattern = this.findUrlPattern(endpoints, this.service.getImplementationClass())) != null) {
                    return URLEncoder.encode(urlPattern, "UTF-8");
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return URLEncoder.encode(this.getNameFromPackageName(this.service.getImplementationClass()), "UTF-8");
    }

    private String findUrlPattern(Endpoints endpoints, String implementationClass) {
        Endpoint[] endp = endpoints.getEndpoints();
        for (int i = 0; i < endp.length; ++i) {
            String urlPattern;
            if (!implementationClass.equals(endp[i].getImplementation()) || (urlPattern = endp[i].getUrlPattern()) == null) continue;
            return urlPattern.startsWith("/") ? urlPattern.substring(1) : urlPattern;
        }
        return null;
    }

    private String getServiceUri(Object moduleType) throws UnsupportedEncodingException {
        List annotations;
        String serviceName = null;
        String name = null;
        boolean isProvider = false;
        JavaClass javaClass = this.getImplBeanClass();
        if (javaClass != null && (annotations = javaClass.getAnnotations()) != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                Annotation an = (Annotation)annotations.get(i);
                if ("javax.jws.WebService".equals(an.getType().getName()) || "javax.xml.ws.WebServiceProvider".equals(an.getType().getName())) {
                    List attrs = an.getAttributeValues();
                    for (int j = 0; j < attrs.size(); ++j) {
                        AttributeValue attr = (AttributeValue)attrs.get(j);
                        if ("serviceName".equals(attr.getName())) {
                            serviceName = ((StringLiteral)attr.getValue()).getValue();
                        } else if ("name".equals(attr.getName())) {
                            name = ((StringLiteral)attr.getValue()).getValue();
                        }
                        if (serviceName == null) continue;
                        if (J2eeModule.WAR.equals(moduleType)) {
                            return URLEncoder.encode(serviceName, "UTF-8");
                        }
                        if (name == null) continue;
                        return URLEncoder.encode(serviceName, "UTF-8") + "/" + URLEncoder.encode(name, "UTF-8");
                    }
                }
                if (!"javax.xml.ws.WebServiceProvider".equals(an.getType().getName())) continue;
                isProvider = true;
            }
        }
        String qualifiedImplClassName = this.service.getImplementationClass();
        String implClassName = this.getNameFromPackageName(qualifiedImplClassName);
        if (serviceName == null) {
            serviceName = implClassName + "Service";
        }
        if (J2eeModule.WAR.equals(moduleType)) {
            return URLEncoder.encode(serviceName, "UTF-8");
        }
        if (J2eeModule.EJB.equals(moduleType)) {
            if (name == null) {
                name = isProvider ? qualifiedImplClassName : implClassName;
            }
            return URLEncoder.encode(serviceName, "UTF-8") + "/" + URLEncoder.encode(name, "UTF-8");
        }
        return URLEncoder.encode(serviceName, "UTF-8");
    }

    private String getNameFromPackageName(String packageName) {
        int index = packageName.lastIndexOf(".");
        return index >= 0 ? packageName.substring(index + 1) : packageName;
    }

    public String getWsdlURL() {
        String wsdlUrl = this.getWebServiceURL();
        return wsdlUrl.length() == 0 ? "" : wsdlUrl + "?wsdl";
    }

    public String getTesterPageURL() {
        if (this.isJsr109Supported(this.project) && Util.isJavaEE5orHigher((Project)this.project)) {
            return this.getWebServiceURL() + "?Tester";
        }
        return this.getWebServiceURL();
    }

    public void refreshService(boolean downloadWsdl) {
        if (downloadWsdl) {
            int result = RefreshWsDialog.open(downloadWsdl, this.service.getImplementationClass(), this.service.getWsdlUrl());
            if (0 == result) {
                return;
            }
            if (4 == result) {
                ((JaxWsChildren)this.getChildren()).refreshKeys(true, true);
            } else if (2 == result) {
                ((JaxWsChildren)this.getChildren()).refreshKeys(true, false);
            } else if (3 == result) {
                ((JaxWsChildren)this.getChildren()).refreshKeys(false, true);
            } else {
                ((JaxWsChildren)this.getChildren()).refreshKeys(false, false);
            }
        } else {
            int result = RefreshWsDialog.openWithOKButtonOnly(downloadWsdl, this.service.getImplementationClass(), this.service.getWsdlUrl());
            if (3 == result) {
                ((JaxWsChildren)this.getChildren()).refreshKeys(false, true);
            } else {
                ((JaxWsChildren)this.getChildren()).refreshKeys(false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        JAXWSSupport wss;
        String serviceName = this.service.getName();
        NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_CONFIRM_DELETE", (Object)serviceName));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
        if (notifyDesc.getValue() == NotifyDescriptor.YES_OPTION && (wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory())) != null) {
            FileObject localWsdlFolder = wss.getLocalWsdlFolderForService(serviceName, false);
            if (localWsdlFolder != null) {
                FileObject serviceWsdlFolder;
                FileLock lock = null;
                FileObject clientArtifactsFolder = localWsdlFolder.getParent();
                try {
                    lock = clientArtifactsFolder.lock();
                    clientArtifactsFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                FileObject wsdlFolder = wss.getWsdlFolder(false);
                if (wsdlFolder != null && (serviceWsdlFolder = wsdlFolder.getFileObject(serviceName)) != null) {
                    try {
                        lock = serviceWsdlFolder.lock();
                        serviceWsdlFolder.delete(lock);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
                FileObject buildImplFo = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
                try {
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-clean-" + serviceName}, null);
                    wsimportTask.waitFinished();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
            }
            wss.removeService(serviceName);
            Boolean isJsr109 = this.jaxWsModel.getJsr109();
            if (isJsr109 != null && !isJsr109.booleanValue()) {
                if (this.service.getWsdlUrl() != null) {
                    serviceName = this.service.getServiceName();
                }
                wss.removeNonJsr109Entries(serviceName);
            }
            super.destroy();
        }
    }

    private JavaClass getImplBeanClass() {
        String implBean = this.service.getImplementationClass();
        if (implBean != null) {
            return JMIUtils.findClass((String)implBean, (FileObject)this.srcRoot);
        }
        return null;
    }

    public Object getValue(String attributeName) {
        Object retValue = attributeName.equals("customDelete") ? Boolean.TRUE : super.getValue(attributeName);
        return retValue;
    }

    public void configureHandler() {
        DialogDescriptor dialogDesc;
        boolean isNew = false;
        this.implBeanClass = this.getImplBeanClass();
        ArrayList<String> handlerClasses = new ArrayList<String>();
        FileObject handlerFO = null;
        HandlerChains handlerChains = null;
        String handlerFileName = null;
        Annotation handlerAnnotation = JaxWsNode.getAnnotation((AnnotableElement)this.implBeanClass, "HandlerChain");
        if (handlerAnnotation != null) {
            FileObject f;
            List attrs = handlerAnnotation.getAttributeValues();
            for (AttributeValue attr : attrs) {
                String attrName = attr.getName();
                if (!attrName.equals("file")) continue;
                StringLiteral fileValue = (StringLiteral)attr.getValue();
                handlerFileName = fileValue.getValue();
                break;
            }
            if ((handlerFO = (f = JavaModel.getFileObject((Resource)this.implBeanClass.getResource())).getParent().getFileObject(handlerFileName)) != null) {
                try {
                    handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(handlerFO);
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return;
                }
                HandlerChain[] handlerChainArray = handlerChains.getHandlerChains();
                HandlerChain chain = handlerChainArray[0];
                Handler[] handlers = chain.getHandlers();
                for (int i = 0; i < handlers.length; ++i) {
                    handlerClasses.add(handlers[i].getHandlerClass());
                }
            } else {
                dialogDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_HANDLER_FILE_NOT_FOUND", (Object)handlerFileName), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
            }
        } else {
            isNew = true;
        }
        MessageHandlerPanel panel = new MessageHandlerPanel(this.project, handlerClasses.toArray(new String[handlerClasses.size()]), true, this.service.getName());
        String title = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        dialogDesc = new DialogDescriptor((Object)panel, title);
        dialogDesc.setButtonListener((ActionListener)new HandlerButtonListener(panel, handlerChains, handlerFO, this.implBeanClass, this.service, isNew));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.setVisible(true);
    }

    public static Annotation getAnnotation(AnnotableElement element, String annotationType) {
        List annotations = element.getAnnotations();
        for (Annotation annotation : annotations) {
            String name;
            if (annotation.getType() == null || (name = annotation.getType().getName()).indexOf(annotationType) == -1) continue;
            return annotation;
        }
        return null;
    }

    private boolean isJsr109Supported(Project project) {
        J2eePlatform j2eePlatform;
        Map properties;
        String serverInstance;
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        if (wss != null && (serverInstance = (String)(properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            return j2eePlatform.isToolSupported("jsr109");
        }
        return false;
    }

    private void addImplClassToContent(final InstanceContent content) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                JavaMetamodel.getManager().waitScanFinished();
                JaxWsNode.this.implBeanClass = JaxWsNode.this.getImplBeanClass();
                if (JaxWsNode.this.implBeanClass != null) {
                    content.add((Object)JaxWsNode.this.implBeanClass);
                }
            }
        });
    }

    void refreshImplClass() {
        if (this.implBeanClass != null) {
            this.content.remove((Object)this.implBeanClass);
        }
        this.addImplClassToContent(this.content);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable clipboardCopy() throws IOException {
        URL url;
        block10: {
            url = new URL(this.getWsdlURL());
            boolean connectionOK = false;
            try {
                URLConnection connection = url.openConnection();
                if (!(connection instanceof HttpURLConnection)) break block10;
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                try {
                    httpConnection.setRequestMethod("GET");
                    httpConnection.connect();
                    if (200 == httpConnection.getResponseCode()) {
                        connectionOK = true;
                    }
                }
                catch (ConnectException ex) {
                    url = null;
                }
                finally {
                    if (httpConnection != null) {
                        httpConnection.disconnect();
                    }
                }
                if (!connectionOK) {
                    url = null;
                }
            }
            catch (IOException ex) {
                url = null;
            }
        }
        return new WebServiceTransferable(new WebServiceReference(url, this.service.getWsdlUrl() != null ? this.service.getServiceName() : this.service.getName(), this.project.getProjectDirectory().getName()));
    }
}

