/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl;

import java.beans.FeatureDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Enumeration;
import org.netbeans.modules.xml.api.model.DTDUtil;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarQueryManager;
import org.openide.util.Enumerations;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSSchemaGrammarQueryMgr
extends GrammarQueryManager {
    private static final String XMLNS_ATTR = "xmlns";
    private static final String JAXRPC_CONFIG_TAG = "configuration";
    private static final String WSDL_DEFINITIONS = "definitions";
    private static final int TYPE_WSDL = 0;
    private static final int TYPE_JAXRPC_CONFIG = 1;
    private static final String PUBLIC_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    private static final String PUBLIC_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final String PUBLIC_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String PUBLIC_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private int schema_type;
    private String prefix;
    private String ns_wsdl;
    private String ns_soap;
    private String ns_soapenc;
    private String ns_schema;

    public Enumeration enabled(GrammarEnvironment ctx) {
        if (ctx.getFileObject() == null) {
            return null;
        }
        Enumeration en = ctx.getDocumentChildren();
        while (en.hasMoreElements()) {
            Node next = (Node)en.nextElement();
            if (next.getNodeType() == 10) {
                this.schema_type = -1;
                return null;
            }
            if (next.getNodeType() != 1) continue;
            this.prefix = null;
            this.ns_wsdl = "wsdl";
            this.ns_soap = "soap";
            this.ns_soapenc = "soapenc";
            this.ns_schema = "xsd";
            Element element = (Element)next;
            String tag = element.getTagName();
            if (JAXRPC_CONFIG_TAG.equals(tag)) {
                String xmlns = element.getAttribute(XMLNS_ATTR);
                if ("http://java.sun.com/xml/ns/jax-rpc/ri/config".equals(xmlns) || "http://java.sun.com/xml/ns/jax-rpc/ri/config/".equals(xmlns)) {
                    this.schema_type = 1;
                    return Enumerations.singleton((Object)next);
                }
            } else if (WSDL_DEFINITIONS.equals(tag)) {
                this.schema_type = 0;
                this.prefix = "";
            } else if (tag.endsWith(":definitions")) {
                this.schema_type = 0;
                this.prefix = tag.substring(0, tag.indexOf(":definitions"));
            }
            if (this.prefix == null) continue;
            NamedNodeMap map = element.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Attr attr = (Attr)map.item(i);
                String name = attr.getName();
                if (!name.startsWith("xmlns:")) continue;
                if (PUBLIC_WSDL.equals(attr.getValue())) {
                    this.ns_wsdl = name.substring(6);
                    continue;
                }
                if (PUBLIC_SOAP.equals(attr.getValue())) {
                    this.ns_soap = name.substring(6);
                    continue;
                }
                if (PUBLIC_SOAPENC.equals(attr.getValue())) {
                    this.ns_soapenc = name.substring(6);
                    continue;
                }
                if (!PUBLIC_SCHEMA.equals(attr.getValue())) continue;
                this.ns_schema = name.substring(6);
            }
            return Enumerations.singleton((Object)next);
        }
        return null;
    }

    public FeatureDescriptor getDescriptor() {
        return new FeatureDescriptor();
    }

    public GrammarQuery getGrammar(GrammarEnvironment ctx) {
        InputSource inputSource = null;
        switch (this.schema_type) {
            case 0: {
                StringBuffer buffer = new StringBuffer();
                if (this.prefix.length() == 0) {
                    buffer.append("<!ENTITY % root_prefix ''>");
                } else {
                    buffer.append("<!ENTITY % root_prefix '" + this.prefix + ":'>");
                }
                buffer.append("<!ENTITY % wsdl '" + this.ns_wsdl + "'>");
                buffer.append("<!ENTITY % soap '" + this.ns_soap + "'>");
                buffer.append("<!ENTITY % soapenc '" + this.ns_soapenc + "'>");
                buffer.append("<!ENTITY % wsdl_prefix '" + this.ns_wsdl + ":'>");
                buffer.append("<!ENTITY % soap_prefix '" + this.ns_soap + ":'>");
                buffer.append("<!ENTITY % p '" + this.ns_schema + ":'><!ENTITY % s ':" + this.ns_schema + "'>");
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/netbeans/modules/websvc/wsdl/resources/wsdl-soap.dtd");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String line = null;
                try {
                    while ((line = br.readLine()) != null) {
                        buffer.append(line);
                    }
                    br.close();
                }
                catch (IOException ex) {
                    return null;
                }
                inputSource = new InputSource(new StringReader(buffer.toString()));
                inputSource.setSystemId("nbres:/org/netbeans/modules/websvc/wsdl/resources/wsdl-soap.dtd");
                break;
            }
            case 1: {
                inputSource = new InputSource("nbres:/org/netbeans/modules/websvc/wsdl/resources/jax-rpc-ri-config_1_1.dtd");
            }
        }
        if (inputSource != null) {
            return DTDUtil.parseDTD((boolean)true, (InputSource)inputSource);
        }
        return null;
    }
}

