/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl;

import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.core.client.nodes.WsCompileConfigCookie;
import org.netbeans.modules.websvc.wsdl.DD2beansDataObject;
import org.netbeans.modules.websvc.wsdl.WsCompileConfigDataNode;
import org.netbeans.modules.websvc.wsdl.config.ConfigurationProxy;
import org.netbeans.modules.websvc.wsdl.config.api.DDProvider;
import org.netbeans.modules.websvc.wsdl.config.api.Wsdl;
import org.netbeans.modules.websvc.wsdl.config.impl.Configuration;
import org.netbeans.modules.websvc.wsdl.xmlutils.SAXParseError;
import org.netbeans.modules.websvc.wsdl.xmlutils.XMLJ2eeDataObject;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;
import org.openide.xml.EntityCatalog;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class WsCompileConfigDataObject
extends DD2beansDataObject
implements WsCompileConfigCookie,
Node.Cookie,
ConfigurationProxy.OutputProvider,
FileChangeListener,
ChangeListener {
    public static final String WSCOMPILE_CONFIG_FILENAME_SUFFIX = "-config";
    public static final String WSCOMPILE_CONFIG_EXTENSION = "xml";
    private WeakReference packageHandlerRef = null;
    private boolean isClientConfig;
    private org.netbeans.modules.websvc.wsdl.config.api.Configuration configuration;
    private FileObjectObserver fileListener;
    private boolean unparsable = true;

    public WsCompileConfigDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.init(pf, loader);
    }

    private void init(FileObject pf, MultiFileLoader loader) {
        this.initClientConfig();
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        this.fileListener = new FileObjectObserver(pf);
    }

    private void initClientConfig() {
        FileObject wsdlFolder;
        WebServicesClientSupport clientSupport;
        this.isClientConfig = false;
        FileObject configFO = this.getPrimaryFile();
        FileObject parentFO = configFO.getParent();
        if (parentFO != null && (clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)configFO)) != null && (wsdlFolder = clientSupport.getWsdlFolder()) != null && wsdlFolder.equals(parentFO)) {
            this.isClientConfig = true;
        }
    }

    public boolean isUnparsable() {
        return this.unparsable;
    }

    public org.netbeans.modules.websvc.wsdl.config.api.Configuration getConfiguration() {
        if (this.configuration == null) {
            this.parsingDocument();
        }
        return this.configuration;
    }

    protected boolean isClientConfig() {
        return this.isClientConfig;
    }

    public boolean isRenameAllowed() {
        return !this.isClientConfig();
    }

    public boolean isDeleteAllowed() {
        return true;
    }

    protected Node createNodeDelegate() {
        return new WsCompileConfigDataNode(this);
    }

    protected String getIconBaseForInvalidDocument() {
        return "org/netbeans/modules/websvc/wsdl/resources/config_broken";
    }

    protected String getIconBaseForValidDocument() {
        return "org/netbeans/modules/websvc/wsdl/resources/config";
    }

    protected String generateDocument() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.configuration.write(out);
            out.close();
            return out.toString("UTF8");
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return out.toString();
    }

    protected String updateDocument(Document doc) {
        return null;
    }

    public void write(org.netbeans.modules.websvc.wsdl.config.api.Configuration configurationProxy) throws IOException {
        org.netbeans.modules.websvc.wsdl.config.api.Configuration config = this.getConfiguration();
        if (config != null) {
            config.merge(configurationProxy, 2);
        }
        this.setNodeDirty(true);
    }

    public FileObject getTarget() {
        return this.getPrimaryFile();
    }

    protected SAXParseError updateNode(InputSource is) throws IOException {
        if (this.configuration == null) {
            try {
                this.configuration = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
                this.firePropertyChange("propertySets", null, null);
                if (this.unparsable) {
                    this.unparsable = false;
                }
                return null;
            }
            catch (RuntimeException ex) {
                if (!this.unparsable) {
                    this.unparsable = true;
                }
                return new SAXParseError(new SAXParseException(ex.getMessage(), new LocatorImpl()));
            }
        }
        Configuration config = null;
        try {
            org.w3c.dom.Document doc = this.getDocument(is);
            config = Configuration.createGraph(doc);
            this.unparsable = false;
        }
        catch (SAXParseException ex) {
            if (!this.unparsable) {
                this.unparsable = true;
            }
            return new SAXParseError(ex);
        }
        catch (SAXException ex) {
            if (!this.unparsable) {
                this.unparsable = true;
            }
            throw new IOException();
        }
        if (config != null) {
            this.configuration.merge(config, 3);
        }
        return null;
    }

    private org.w3c.dom.Document getDocument(InputSource inputSource) throws SAXParseException {
        try {
            org.w3c.dom.Document doc = GraphManager.createXmlDocument((InputSource)inputSource, (boolean)false, (EntityResolver)EntityCatalog.getDefault(), (ErrorHandler)new XMLJ2eeDataObject.J2eeErrorHandler(this));
            return doc;
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), new LocatorImpl());
        }
    }

    public String getServicePackageName() {
        Wsdl wsdl;
        String packageName = null;
        org.netbeans.modules.websvc.wsdl.config.api.Configuration cfg = this.getConfiguration();
        if (cfg != null && (wsdl = cfg.getWsdl()) != null) {
            packageName = wsdl.getPackageName();
        }
        return packageName;
    }

    public void setServicePackageName(String newPackage) {
        org.netbeans.modules.websvc.wsdl.config.api.Configuration cfg = this.getConfiguration();
        if (cfg != null) {
            Wsdl wsdl = cfg.getWsdl();
            if (wsdl != null) {
                wsdl.setPackageName(newPackage);
            }
            try {
                cfg.write(this.getTarget());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
    }

    protected void handleDelete() throws IOException {
        if (this.isClientConfig()) {
            super.handleDelete();
        } else {
            super.handleDelete();
        }
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataObject dObj = super.handleCopy(f);
        try {
            dObj.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dObj;
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void stateChanged(ChangeEvent e) {
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private class FileObjectObserver
    implements FileChangeListener {
        FileObjectObserver(FileObject fo) {
            fo.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)((Object)this), (Object)fo));
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            ConfigurationProxy config = (ConfigurationProxy)WsCompileConfigDataObject.this.getConfiguration();
            boolean needRewriting = true;
            if (config != null && config.isWriting()) {
                config.setWriting(false);
                needRewriting = false;
            }
            if (WsCompileConfigDataObject.this.isSavingDocument()) {
                WsCompileConfigDataObject.this.setSavingDocument(false);
                needRewriting = false;
            }
            if (needRewriting) {
                WsCompileConfigDataObject.this.getEditorSupport().restartTimer();
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }
    }
}

