/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;
import org.netbeans.spi.debugger.jpda.EditorContext;

public class Context {
    private static EditorContext editorContext;

    private static EditorContext getContext() {
        if (editorContext == null) {
            List l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            editorContext = (EditorContext)l.get(0);
        }
        return editorContext;
    }

    public static boolean showSource(String url, int lineNumber, Object timeStamp) {
        return Context.getContext().showSource(url, lineNumber, timeStamp);
    }

    public static Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return Context.getContext().annotate(url, lineNumber, annotationType, timeStamp);
    }

    public static void removeAnnotation(Object annotation) {
        Context.getContext().removeAnnotation(annotation);
    }

    public static int getLineNumber(Object annotation, Object timeStamp) {
        return Context.getContext().getLineNumber(annotation, timeStamp);
    }

    public static int getCurrentLineNumber() {
        return Context.getContext().getCurrentLineNumber();
    }

    public static String getCurrentURL() {
        return Context.getContext().getCurrentURL();
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        Context.getContext().addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        Context.getContext().removePropertyChangeListener(l);
    }

    public static void createTimeStamp(Object timeStamp) {
        Context.getContext().createTimeStamp(timeStamp);
    }

    public static void disposeTimeStamp(Object timeStamp) {
        Context.getContext().disposeTimeStamp(timeStamp);
    }

    public static String getFileName(JspLineBreakpoint b) {
        try {
            return new File(new URL(b.getURL()).getFile()).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean showSource(JspLineBreakpoint b) {
        if (b.getLineNumber() < 1) {
            return Context.showSource(b.getURL(), 1, null);
        }
        return Context.showSource(b.getURL(), b.getLineNumber(), null);
    }

    public static Object annotate(JspLineBreakpoint b) {
        boolean isConditional;
        String url = b.getURL();
        int lineNumber = b.getLineNumber();
        if (lineNumber < 1) {
            return null;
        }
        String condition = b.getCondition();
        boolean bl = isConditional = condition != null && !condition.trim().equals("");
        String annotationType = b.isEnabled() ? (isConditional ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (isConditional ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return Context.annotate(url, lineNumber, annotationType, null);
    }
}

