/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Bean;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Methods;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.IndentEngine;
import org.openide.util.RequestProcessor;

public class EjbGenerationUtil {
    public static final String TEMPLATE_BASE = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/";
    public static final String INTERFACE_TEMPLATE = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/EJBInterface.xml";
    private static final String BUSINESS_INTF_TEMPLATE = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/BusinessInterface.xml";
    private static final String BUSINESS_INTF_TEMPLATE_EJB30 = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/BusinessInterface.xml";
    private static final String[] EJB_NAME_CONTEXTS = new String[]{"Session", "Entity", "MessageDriven"};
    private String genDate;
    private String genAuthor;
    private Map templateCache = new HashMap();

    public Bean getDefaultBean() {
        Bean b = new Bean();
        b.setCommentData(true);
        if (this.genDate == null) {
            this.genDate = DateFormat.getDateTimeInstance().format(new Date());
            this.genAuthor = System.getProperty("user.name");
        }
        b.setCommentDataAuthor(this.genAuthor);
        b.setCommentDataDate(this.genDate);
        return b;
    }

    private Transformer getTransformer(String template) throws TransformerConfigurationException {
        Transformer t = (Transformer)this.templateCache.get(template);
        if (t != null) {
            return t;
        }
        BufferedInputStream is = new BufferedInputStream(this.getClass().getResourceAsStream(template));
        TransformerFactory transFactory = TransformerFactory.newInstance();
        transFactory.setURIResolver(new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                InputStream is = this.getClass().getResourceAsStream(EjbGenerationUtil.TEMPLATE_BASE + href.substring(href.lastIndexOf(47) + 1));
                if (is == null) {
                    return null;
                }
                return new StreamSource(is);
            }
        });
        t = transFactory.newTemplates(new StreamSource(is)).newTransformer();
        this.templateCache.put(template, t);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StreamSource getStreamSource(Methods genData) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            genData.write(bos);
        }
        finally {
            bos.close();
        }
        return new StreamSource(new ByteArrayInputStream(bos.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StreamSource getStreamSource(Bean genData) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            genData.write(bos);
        }
        finally {
            bos.close();
        }
        return new StreamSource(new ByteArrayInputStream(bos.toByteArray()));
    }

    public void generateBusinessInterfaces(String pkg, FileObject foPkg, String businessInterfaceName, String ejbName, String beanClass, String intf) throws IOException {
        this.generateBusinessInterfaces(pkg, foPkg, businessInterfaceName, ejbName, beanClass, intf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBusinessInterfaces(String pkg, FileObject foPkg, String businessInterfaceName, String ejbName, String beanClass, String intf, boolean simplified) throws IOException {
        String shortName = EjbGenerationUtil.getBaseName(businessInterfaceName);
        Methods m = new Methods();
        m.setPackage(pkg);
        m.setEjbName(ejbName);
        m.setClassname(shortName);
        shortName = this.genClass(simplified ? "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/BusinessInterface.xml" : "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/BusinessInterface.xml", foPkg, m, false);
        FileObject binFo = foPkg.getFileObject(shortName, "java");
        assert (binFo != null) : "businessInterfaceName class " + businessInterfaceName + " not found in " + foPkg;
        FileObject beanFo = foPkg.getFileObject(EjbGenerationUtil.getBaseName(beanClass), "java");
        assert (beanFo != null) : "bean class " + beanClass + " not found in " + foPkg;
        Resource res = JavaModel.getResource((FileObject)beanFo);
        List classes = res.getClassifiers();
        assert (classes.size() == 1) : "" + FileUtil.getFileDisplayName((FileObject)beanFo) + " should contain one class, not " + classes.size();
        JavaClass beani = (JavaClass)classes.get(0);
        JavaMetamodel.getDefaultRepository().beginTrans(true);
        boolean err = true;
        try {
            JavaMetamodel.getManager().setClassPath(binFo);
            JMIUtils.addInterface((JavaClass)beani, (String)businessInterfaceName);
            if (!simplified) {
                FileObject intfFo = foPkg.getFileObject(EjbGenerationUtil.getBaseName(intf), "java");
                assert (intfFo != null) : "interface class " + intfFo + " not found in " + foPkg;
                res = JavaModel.getResource((FileObject)intfFo);
                classes = res.getClassifiers();
                assert (classes.size() == 1) : "" + res + " should contain just one class";
                JavaClass infi = (JavaClass)classes.get(0);
                JMIUtils.addInterface((JavaClass)infi, (String)businessInterfaceName);
            }
            err = false;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans(err);
        }
    }

    public String genClass(String template, FileObject pkg, Methods methods, boolean open) throws IOException {
        String actualClsName = FileUtil.findFreeFileName((FileObject)pkg, (String)methods.getClassname(), (String)"java");
        methods.setClassname(actualClsName);
        this.generateClass(template, pkg, actualClsName, EjbGenerationUtil.getStreamSource(methods), open);
        return actualClsName;
    }

    public void generateClass(String template, FileObject pkg, String clsName, StreamSource source, boolean open) throws IOException {
        FileObject cFile = pkg.createData(clsName, "java");
        FileLock fl = null;
        OutputStream os = null;
        Writer w = null;
        try {
            fl = cFile.lock();
            os = new BufferedOutputStream(cFile.getOutputStream(fl));
            this.getTransformer(template).transform(source, new StreamResult(new OutputStreamWriter(os)));
            os.close();
            fl.releaseLock();
            DataObject dobj = DataObject.find((FileObject)cFile);
            final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument d = ec.openDocument();
            try {
                String fullText = d.getText(0, d.getLength());
                IndentEngine javaIndent = IndentEngine.find((Document)d);
                StringWriter writer = new StringWriter(d.getLength());
                w = javaIndent.createWriter((Document)d, 0, (Writer)writer);
                w.write(fullText);
                w.close();
                d.remove(0, d.getLength());
                d.insertString(0, writer.getBuffer().toString(), null);
                ec.saveDocument();
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
            }
            if (open) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        ec.open();
                    }
                }, 1000);
            }
        }
        catch (TransformerConfigurationException tce) {
            IOException ioe = new IOException();
            ioe.initCause(tce);
            throw ioe;
        }
        catch (TransformerException te) {
            IOException ioe = new IOException();
            ioe.initCause(te);
            throw ioe;
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (w != null) {
                w.close();
            }
            if (fl != null) {
                fl.releaseLock();
            }
        }
    }

    public String generateBeanClass(String template, Bean genData, String pkgName, FileObject pkg, boolean open) throws IOException {
        String clsName = genData.getClassnameName();
        clsName = FileUtil.findFreeFileName((FileObject)pkg, (String)clsName, (String)"java");
        genData.setClassnameName(clsName);
        this.generateClass(template, pkg, clsName, EjbGenerationUtil.getStreamSource(genData), open);
        return EjbGenerationUtil.getFullClassName(pkgName, clsName);
    }

    public String generateBeanClass(String template, Bean genData, String pkgName, FileObject pkg) throws IOException {
        return this.generateBeanClass(template, genData, pkgName, pkg, true);
    }

    public static String getBeanClassName(String ejbName) {
        return EjbGenerationUtil.getEjbNameBase(ejbName) + "Bean";
    }

    public static String getBusinessInterfaceName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "RemoteBusiness");
    }

    public static String getLocalBusinessInterfaceName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "LocalBusiness");
    }

    public static String getLocalHomeName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "LocalHome");
    }

    public static String getLocalName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "Local");
    }

    public static String getHomeName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "RemoteHome");
    }

    public static String getKeyName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "PK");
    }

    public static String getRemoteName(String pkg, String ejbName) {
        return EjbGenerationUtil.getFullClassName(pkg, EjbGenerationUtil.getEjbNameBase(ejbName) + "Remote");
    }

    public static String getFullClassName(String pkg, String className) {
        return pkg == null || pkg.length() == 0 ? className : pkg + "." + className;
    }

    public static String getBaseName(String fullClassName) {
        return fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
    }

    public static String[] getPackages(Project p) {
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = sources.getSourceGroups("java");
        TreeSet pkgs = new TreeSet();
        for (int i = 0; i < groups.length; ++i) {
            EjbGenerationUtil.findPackages(groups[i].getRootFolder(), "", pkgs);
        }
        return pkgs.toArray(new String[pkgs.size()]);
    }

    private static void findPackages(FileObject root, String curPkg, Set pkgs) {
        FileObject[] kids = root.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].isFolder()) continue;
            String name = curPkg + (curPkg.length() != 0 ? "." : "") + kids[i].getName();
            pkgs.add(name);
            EjbGenerationUtil.findPackages(kids[i], name, pkgs);
        }
    }

    public static boolean isEjbNameInDD(String ejbName, EjbJar dd) {
        EnterpriseBeans beans = dd.getEnterpriseBeans();
        CommonDDBean ejb = null;
        if (beans != null) {
            for (int i = 0; i < EJB_NAME_CONTEXTS.length && (ejb = beans.findBeanByName(EJB_NAME_CONTEXTS[i], "EjbName", ejbName)) == null; ++i) {
            }
        }
        return beans != null && ejb != null;
    }

    public static String uniqueSingleEjbName(String componentName, EjbJar dd) {
        int uniquifier = 1;
        if (!componentName.equalsIgnoreCase("Bean") && componentName.endsWith("Bean")) {
            componentName = componentName.substring(0, componentName.length() - 4);
        }
        String newName = componentName;
        while (EjbGenerationUtil.isEjbNameInDD(newName + "Bean", dd)) {
            newName = componentName + String.valueOf(uniquifier++);
        }
        return newName;
    }

    public static String getEjbNameBase(String ejbName) {
        return ejbName.endsWith("Bean") ? ejbName.substring(0, ejbName.length() - 4) : ejbName;
    }

    public static FileObject getPackageFileObject(SourceGroup location, String pkgName, Project p) {
        String relativePkgName = pkgName.replace('.', '/');
        FileObject fo = null;
        fo = location.getRootFolder().getFileObject(relativePkgName);
        if (fo != null) {
            return fo;
        }
        File rootFile = FileUtil.toFile((FileObject)location.getRootFolder());
        File pkg = new File(rootFile, relativePkgName);
        pkg.mkdirs();
        fo = location.getRootFolder().getFileObject(relativePkgName);
        return fo;
    }

    public static String getSelectedPackageName(FileObject targetFolder, Project p) {
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = sources.getSourceGroups("java");
        String packageName = null;
        for (int i = 0; i < groups.length && packageName == null; ++i) {
            packageName = FileUtil.getRelativePath((FileObject)groups[i].getRootFolder(), (FileObject)targetFolder);
        }
        if (packageName != null) {
            packageName = packageName.replaceAll("/", ".");
        }
        return packageName + "";
    }

    public String generateInterface(String pkg, FileObject foPkg, String className, String ejbName, String genInterface, Method[] primaryMethods) throws IOException {
        className = EjbGenerationUtil.getBaseName(className);
        Methods gen = new Methods();
        gen.setPackage(pkg);
        gen.setClassname(className);
        gen.setEjbName(ejbName);
        gen.setGenInterface(genInterface);
        if (primaryMethods != null) {
            for (int i = 0; i < primaryMethods.length; ++i) {
                if (primaryMethods[i] == null) continue;
                gen.addMethod(primaryMethods[i]);
            }
        }
        return EjbGenerationUtil.getFullClassName(pkg, this.genClass(INTERFACE_TEMPLATE, foPkg, gen, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPKGetter(Entity entity, FileObject classFO, boolean remote) {
        String pkField = entity.getPrimkeyField();
        if (pkField == null) {
            return;
        }
        Resource resource = JavaModel.getResource((FileObject)classFO);
        List classes = resource.getClassifiers();
        JavaClass javaClass = (JavaClass)classes.get(0);
        JavaMetamodel.getDefaultRepository().beginTrans(true);
        boolean err = true;
        try {
            JavaMetamodel.getManager().setClassPath(resource);
            org.netbeans.jmi.javamodel.Method getMethod = JMIUtils.createMethod((JavaClass)javaClass);
            getMethod.setTypeName((TypeReference)JMIUtils.createMultipartId((Feature)javaClass, (String)entity.getPrimKeyClass()));
            getMethod.setName(EntityMethodController.getMethodName(pkField, true));
            if (remote) {
                JMIUtils.addException((org.netbeans.jmi.javamodel.Method)getMethod, (String)"java.rmi.RemoteException");
            }
            List infFeatures = javaClass.getFeatures();
            infFeatures.add(getMethod);
            err = false;
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans(err);
        }
    }
}

