/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.MethodChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class SessionChildren
extends Children.Keys
implements PropertyChangeListener {
    private static final String REMOTE_KEY = "remote";
    private static final String LOCAL_KEY = "local";
    private final Session model;
    private final ClassPath srcPath;
    private final SessionMethodController controller;
    private final EjbJar jar;

    public SessionChildren(Session model, ClassPath srcPath, EjbJar jar) {
        this.srcPath = srcPath;
        this.model = model;
        this.jar = jar;
        this.controller = new SessionMethodController(model, srcPath);
    }

    protected void addNotify() {
        super.addNotify();
        this.updateKeys();
        this.model.addPropertyChangeListener((PropertyChangeListener)this);
        this.srcPath.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updateKeys() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ArrayList<String> keys = new ArrayList<String>();
                if (SessionChildren.this.model.getRemote() != null) {
                    keys.add(SessionChildren.REMOTE_KEY);
                }
                if (SessionChildren.this.model.getLocal() != null) {
                    keys.add(SessionChildren.LOCAL_KEY);
                }
                SessionChildren.this.setKeys(keys);
            }
        });
    }

    protected void removeNotify() {
        this.model.removePropertyChangeListener((PropertyChangeListener)this);
        this.srcPath.removePropertyChangeListener((PropertyChangeListener)this);
        this.setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }

    protected Node[] createNodes(Object key) {
        if (LOCAL_KEY.equals(key)) {
            MethodChildren c = new MethodChildren(this.controller, this.controller.getLocalInterfaces(), true);
            MethodsNode n = new MethodsNode((EntityAndSession)this.model, this.jar, this.srcPath, (Children)c, true);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/LocalMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_LocalMethods"));
            return new Node[]{n};
        }
        if (REMOTE_KEY.equals(key)) {
            MethodChildren c = new MethodChildren(this.controller, this.controller.getRemoteInterfaces(), false);
            MethodsNode n = new MethodsNode((EntityAndSession)this.model, this.jar, this.srcPath, (Children)c, false);
            n.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/RemoteMethodContainerIcon.gif");
            n.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_RemoteMethods"));
            return new Node[]{n};
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SessionChildren.this.updateKeys();
            }
        });
    }
}

