/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.retriever.InfoCollector;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class ImportDirectory
implements Runnable {
    private File importRoot;
    private File toDir;
    private Thread myThread;
    private boolean overWriteFiles = false;
    InfoCollector infoCollector = null;
    Map<File, File> copiedFiles;
    Map<File, File> errorsWhileCopyFiles;
    static final String opTabTitle = NbBundle.getMessage(ImportDirectory.class, (String)"TITLE_retriever_output_tab_title");

    public ImportDirectory(File importRoot, File toDir) {
        this(importRoot, toDir, false);
    }

    public ImportDirectory(File importRoot, File toDir, boolean overWriteFiles) {
        InputOutput io = IOProvider.getDefault().getIO(opTabTitle, false);
        OutputWriter optab = io.getOut();
        io.select();
        try {
            optab.reset();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.copiedFiles = new HashMap<File, File>();
        this.errorsWhileCopyFiles = new HashMap<File, File>();
        this.importRoot = importRoot;
        this.toDir = toDir;
        this.overWriteFiles = overWriteFiles;
        this.start();
    }

    public void setOverwriteFiles(boolean overWriteFiles) {
        this.overWriteFiles = overWriteFiles;
    }

    public void start() {
        this.myThread = new Thread(this);
        int priority = Thread.currentThread().getPriority() - 2;
        this.myThread.setPriority(priority);
        this.myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportDirectory.class, (String)"LBL_PROGRESSBAR_Retrieve_XML"));
        ph.start();
        ph.switchToIndeterminate();
        try {
            this.infoCollector = new InfoCollector(this.importRoot);
            if (this.infoCollector.hasReports()) {
                if (this.infoCollector.hasErrors()) {
                    String errorMess = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_directory_closure_error");
                    NotifyDescriptor.Message ndm = new NotifyDescriptor.Message((Object)errorMess, 0);
                    this.opErrors();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)ndm);
                    return;
                }
                if (this.infoCollector.hasWarnings()) {
                    String warningMess = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_absolute_resource_warning");
                    String warningTitle = NbBundle.getMessage(ImportDirectory.class, (String)"TITLE_absolute_resource_warning");
                    NotifyDescriptor.Confirmation ndc = new NotifyDescriptor.Confirmation((Object)warningMess, warningTitle, 0, 2);
                    this.opWarnings();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)ndc);
                    if (ndc.getValue() == NotifyDescriptor.Confirmation.NO_OPTION) {
                        return;
                    }
                }
            }
            this.copyFiles();
            this.showCopiedFiles();
        }
        finally {
            ph.finish();
        }
        this.invokeRetrieverEngineIfRequired();
    }

    private void copyFiles() {
        List<File> copyList = this.infoCollector.getCopyableFileList();
        for (File srcFile : copyList) {
            FileObject source = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)srcFile));
            String impRootStr = this.importRoot.toURI().toString();
            String toDirStr = this.toDir.toURI().toString();
            StringBuffer strBuff = new StringBuffer(srcFile.toURI().toString());
            String destStr = strBuff.replace(0, impRootStr.length() - 1, toDirStr).toString();
            File destFile = null;
            try {
                destFile = new File(new URI(destStr));
            }
            catch (URISyntaxException ex) {
                continue;
            }
            if (source == null) {
                this.errorsWhileCopyFiles.put(srcFile, destFile);
                continue;
            }
            if (destFile.isFile() && this.overWriteFiles) {
                destFile.delete();
            }
            String fileName = destFile.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
            File destParent = destFile.getParentFile();
            destParent.mkdirs();
            FileObject destParentFOB = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)destParent));
            try {
                FileUtil.copyFile((FileObject)source, (FileObject)destParentFOB, (String)fileName);
            }
            catch (IOException ex) {
                this.errorsWhileCopyFiles.put(srcFile, destFile);
                continue;
            }
            this.copiedFiles.put(srcFile, destFile);
        }
    }

    private void showCopiedFiles() {
        InputOutput io = IOProvider.getDefault().getIO(opTabTitle, false);
        io.setErrSeparated(true);
        OutputWriter error = io.getErr();
        OutputWriter output = io.getOut();
        if (this.errorsWhileCopyFiles.size() > 0) {
            error.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_errors_while_copy"));
            for (File file : this.errorsWhileCopyFiles.keySet()) {
                error.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_from_target", (Object)file.toString(), (Object)this.errorsWhileCopyFiles.get(file).toString()));
            }
        }
        error.close();
        if (this.copiedFiles.size() > 0) {
            output.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_list_of_files_ret"));
            for (File file : this.copiedFiles.keySet()) {
                output.println(NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_from_copied", (Object)file.toString(), (Object)this.copiedFiles.get(file).toString()));
            }
        }
        output.close();
    }

    private void opErrors() {
        InputOutput io = IOProvider.getDefault().getIO(opTabTitle, false);
        io.setErrSeparated(true);
        OutputWriter error = io.getErr();
        String errorMess = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_directory_closure");
        Map<File, List<InfoCollector.InfoEntry>> errors = this.infoCollector.getErrors();
        error.printf("\n%s (%d):\n", new Object[]{errorMess, errors.size()});
        for (File file : errors.keySet()) {
            String msgFileStr = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_file");
            error.printf("%s %s\n", new Object[]{msgFileStr, file.toString()});
            List<InfoCollector.InfoEntry> entList = errors.get(file);
            String msgOverfloLoc = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_overflowing_location");
            for (InfoCollector.InfoEntry ent : entList) {
                error.printf("    %s %s\n", new Object[]{msgOverfloLoc, ent.getChildStr()});
            }
        }
        error.close();
    }

    private void opWarnings() {
        InputOutput io = IOProvider.getDefault().getIO(opTabTitle, false);
        io.setErrSeparated(true);
        OutputWriter error = io.getErr();
        String errorMess = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_absolute_resource");
        Map<File, List<InfoCollector.InfoEntry>> errors = this.infoCollector.getWarnings();
        error.printf("\n%s (%d):\n", new Object[]{errorMess, errors.size()});
        for (File file : errors.keySet()) {
            String msgFileStr = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_file");
            error.printf("%s %s\n", new Object[]{msgFileStr, file.toString()});
            List<InfoCollector.InfoEntry> entList = errors.get(file);
            String msgAbsLoc = NbBundle.getMessage(ImportDirectory.class, (String)"MSG_OUTPUT_absolute_location");
            for (InfoCollector.InfoEntry ent : entList) {
                error.printf("    %s %s\n", new Object[]{msgAbsLoc, ent.getChildStr()});
            }
        }
        error.close();
    }

    private void invokeRetrieverEngineIfRequired() {
        Map<File, List<InfoCollector.InfoEntry>> errors = this.infoCollector.getAbsURL2Info();
        for (File file : errors.keySet()) {
            List<InfoCollector.InfoEntry> entList = errors.get(file);
            for (InfoCollector.InfoEntry ent : entList) {
                InfoCollector.InfoType cfr_ignored_0 = ent.infoType;
                if (ent.getInfoType() != InfoCollector.InfoType.url) continue;
                String urlStr = ent.getChildStr();
                URL url = null;
                try {
                    url = new URL(urlStr);
                }
                catch (MalformedURLException ex) {
                    continue;
                }
                RetrieverEngine instance = new RetrieverEngine(this.toDir);
                RetrieveEntry rent = null;
                rent = new RetrieveEntry(null, url.toString(), file, null, Utilities.DocumentTypesEnum.schema, true);
                instance.addResourceToRetrieve(rent);
                instance.start();
            }
        }
    }
}

