/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class JavadocSearchType
extends ServiceType {
    static final long serialVersionUID = -7643543247564581246L;
    private Pattern[] overviewLabelFilters;

    public abstract FileObject getDocFileObject(FileObject var1);

    private synchronized void prepareOverviewFilter() {
        if (this.overviewLabelFilters != null) {
            return;
        }
        String filter = NbBundle.getMessage((Class)JavadocSearchType.class, (String)"FILTER_OverviewIndiceLabel");
        StringTokenizer tok = new StringTokenizer(filter, "\n");
        LinkedList<Pattern> ll = new LinkedList<Pattern>();
        while (tok.hasMoreTokens()) {
            try {
                String expr = tok.nextToken();
                Pattern re = Pattern.compile(expr);
                ll.add(re);
            }
            catch (PatternSyntaxException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        this.overviewLabelFilters = ll.toArray(new Pattern[ll.size()]);
    }

    public String getOverviewTitleBase(String overviewTitle) {
        this.prepareOverviewFilter();
        String t = overviewTitle.trim();
        for (int i = 0; i < this.overviewLabelFilters.length; ++i) {
            Matcher match = this.overviewLabelFilters[i].matcher(t);
            if (!match.matches()) continue;
            return match.group(1);
        }
        return overviewTitle;
    }

    public abstract IndexSearchThread getSearchThread(String var1, FileObject var2, IndexSearchThread.DocIndexItemConsumer var3);

    public abstract boolean accepts(FileObject var1, String var2);
}

