/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.modules.schema2beans.GraphManager;
import org.netbeans.modules.web.struts.SAXParseError;
import org.netbeans.modules.web.struts.StrutsCatalog;
import org.netbeans.modules.web.struts.StrutsConfigEditorSupport;
import org.netbeans.modules.web.struts.StrutsConfigLoader;
import org.netbeans.modules.web.struts.StrutsConfigNode;
import org.netbeans.modules.web.struts.config.model.StrutsConfig;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class StrutsConfigDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static StrutsCatalog strutsCatalog = new StrutsCatalog();
    private boolean documentDirty = true;
    private boolean documentValid = true;
    protected boolean nodeDirty = false;
    private InputStream inputStream;
    private SAXParseError error;
    private StrutsConfig lastGoodConfig = null;
    private transient StrutsConfigEditorSupport editorSupport;
    public static final String PROP_DOC_VALID = "documentValid";

    public StrutsConfigDataObject(FileObject pf, StrutsConfigLoader loader) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.init();
    }

    private void init() {
        CookieSet cookies = this.getCookieSet();
        this.getCookieSet().add(StrutsConfigEditorSupport.class, (CookieSet.Factory)this);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
    }

    protected synchronized Node createNodeDelegate() {
        return new StrutsConfigNode(this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(StrutsConfigEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StrutsConfigEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            StrutsConfigDataObject strutsConfigDataObject = this;
            synchronized (strutsConfigDataObject) {
                if (this.editorSupport == null) {
                    this.editorSupport = new StrutsConfigEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }

    public StrutsConfig getStrutsConfig() throws IOException {
        if (this.lastGoodConfig == null) {
            this.parsingDocument();
        }
        return this.lastGoodConfig;
    }

    public StrutsConfig getStrutsConfig(boolean parsenow) throws IOException {
        if (parsenow) {
            StrutsConfig previous = this.lastGoodConfig;
            this.parsingDocument();
            if (this.lastGoodConfig == null) {
                this.lastGoodConfig = previous;
            }
        }
        return this.getStrutsConfig();
    }

    protected InputStream prepareInputSource() throws IOException {
        if (this.getEditorSupport() != null && this.getEditorSupport().isDocumentLoaded()) {
            return this.getEditorSupport().getInputStream();
        }
        return this.getPrimaryFile().getInputStream();
    }

    protected void closeInputSource() {
        InputStream is = this.inputStream;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (is == this.inputStream) {
                this.inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(StrutsConfig config) throws IOException {
        File file = FileUtil.toFile((FileObject)this.getPrimaryFile());
        FileObject configFO = this.getPrimaryFile();
        try {
            FileLock lock = configFO.lock();
            try {
                OutputStream os = configFO.getOutputStream(lock);
                try {
                    config.write(os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (FileAlreadyLockedException ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsingDocument() {
        this.error = null;
        try {
            this.error = this.updateNode(this.prepareInputSource());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            this.setDocumentValid(false);
            return;
        }
        finally {
            this.closeInputSource();
            this.documentDirty = false;
        }
        if (this.error == null) {
            this.setDocumentValid(true);
        } else {
            this.setDocumentValid(false);
        }
        this.setNodeDirty(false);
    }

    public void setDocumentValid(boolean valid) {
        if (this.documentValid != valid) {
            if (valid) {
                this.repairNode();
            }
            this.documentValid = valid;
            this.firePropertyChange(PROP_DOC_VALID, !this.documentValid ? Boolean.TRUE : Boolean.FALSE, this.documentValid ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void repairNode() {
        StatusDisplayer.getDefault().setStatusText("");
    }

    private Document getDomDocument(InputStream inputSource) throws SAXParseException {
        try {
            Document doc = GraphManager.createXmlDocument((InputSource)new InputSource(inputSource), (boolean)false, (EntityResolver)strutsCatalog, (ErrorHandler)new J2eeErrorHandler(this));
            return doc;
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), new LocatorImpl());
        }
    }

    protected SAXParseError updateNode(InputStream is) throws IOException {
        try {
            Document doc = this.getDomDocument(is);
            this.lastGoodConfig = StrutsConfig.createGraph(doc);
        }
        catch (SAXParseException ex) {
            return new SAXParseError(ex);
        }
        catch (SAXException ex) {
            throw new IOException();
        }
        return null;
    }

    public boolean isDocumentValid() {
        return this.documentValid;
    }

    public void setDocumentDirty(boolean dirty) {
        this.documentDirty = dirty;
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    public boolean isNodeDirty() {
        return this.nodeDirty;
    }

    public void setNodeDirty(boolean dirty) {
        this.nodeDirty = dirty;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    private void createSAXParseError(SAXParseException error) {
        this.error = new SAXParseError(error);
    }

    public static class J2eeErrorHandler
    implements ErrorHandler {
        private StrutsConfigDataObject dataObject;

        public J2eeErrorHandler(StrutsConfigDataObject obj) {
            this.dataObject = obj;
        }

        public void error(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.dataObject.createSAXParseError(exception);
            throw exception;
        }
    }
}

