/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.autoupdate.AutoCheckInfo;
import org.netbeans.modules.autoupdate.AutoupdateType;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.AvailableUpdateVisualizerProvider;
import org.netbeans.modules.autoupdate.ConnectingErrorDialog;
import org.netbeans.modules.autoupdate.ProblemsVisualizerProvider;
import org.netbeans.modules.autoupdate.Settings;
import org.netbeans.modules.autoupdate.Updates;
import org.netbeans.modules.autoupdate.Wizard;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AutoChecker
implements Runnable,
Wizard.Validator {
    private Settings settings;
    private Updates updates;
    private HashMap allUpdates = new HashMap();
    static AutoChecker autoChecker;
    private RequestProcessor.Task regularlyCheck = null;
    static final RequestProcessor REGULARLY_CHECK_TIMER;
    private boolean canceled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void doCheck() {
        autoChecker.run();
    }

    AutoChecker() {
        this.settings = Settings.getShared();
    }

    void install() {
        Autoupdater.installUpdateChecker(this);
        autoChecker = this;
    }

    public void run() {
        AutoCheckInfo info;
        this.canceled = false;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        if (!this.timeToCheck()) {
            return;
        }
        if (this.settings.isAskBefore() && !(info = new AutoCheckInfo(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Before"), 1)).showDialog(true)) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                AutoChecker.this.runInner();
            }
        });
    }

    void runInner() {
        Wizard.resetErrorStore();
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)AutoChecker.class, (String)"CTL_Checking_StatusText"));
        Enumeration en = AutoupdateType.autoupdateTypes();
        int countOfServer = 0;
        int countOfConnectedServer = 0;
        while (en.hasMoreElements()) {
            AutoupdateType at = (AutoupdateType)((Object)en.nextElement());
            if (!at.isEnabled()) continue;
            ++countOfServer;
            this.updates = at.connectForUpdates();
            this.updates.checkUpdates(this, at, true);
            int res = Wizard.checkConnect(this.updates, at);
            if (res == 0 && (this.updates.getTimeStamp() == null || at.getLastTimeStamp() == null || at.getLastTimeStamp().before(this.updates.getTimeStamp()))) {
                this.allUpdates.put(at, this.updates);
                ++countOfConnectedServer;
                continue;
            }
            if (res != 2 || Wizard.getStoredErrorType() != 4) continue;
            ++countOfConnectedServer;
        }
        boolean success = true;
        if (countOfConnectedServer == 0) {
            StatusDisplayer.getDefault().setStatusText("");
            this.canceled = true;
            if (Wizard.isErrorStored() && 5 == Wizard.getStoredErrorType()) {
                this.notifyError(5);
                success = false;
            } else if (countOfServer != 0 && this.settings.isNegativeResults()) {
                this.notifyNoUpdatesFound();
            }
            return;
        }
        this.reportResults(success);
    }

    void reportResults(boolean success) {
        StatusDisplayer.getDefault().setStatusText("");
        if (success) {
            this.settings.setLastCheck(new Date());
        }
        if (this.canceled || !success) {
            return;
        }
        if (this.allUpdates.size() == 0) {
            if (this.settings.isNegativeResults()) {
                this.notifyNoUpdatesFound();
            }
            return;
        }
        if (this.getAllModules() != null && this.getAllModules().size() > 0) {
            this.notifyUpdates();
        } else if (this.settings.isNegativeResults()) {
            this.notifyNoUpdatesFound();
        }
    }

    private void notifyUpdates() {
        Runnable onMouseClick = new Runnable(){

            public void run() {
                Wizard.go(AutoChecker.this.allUpdates);
            }
        };
        AvailableUpdateVisualizerProvider.UpdatesFlasher flasher = AvailableUpdateVisualizerProvider.getFlasher(onMouseClick);
        if (!$assertionsDisabled && flasher == null) {
            throw new AssertionError((Object)"Updates Flasher cannot be null.");
        }
        flasher.setToolTipText(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Found_ToolTip"));
        flasher.startFlashing();
    }

    private void notifyNoUpdatesFound() {
        Runnable onMouseClick = new Runnable(){

            public void run() {
                AutoChecker.this.noUpdatesFound();
            }
        };
        ProblemsVisualizerProvider.UpdatesFlasher flasher = ProblemsVisualizerProvider.getFlasher(onMouseClick);
        if (!$assertionsDisabled && flasher == null) {
            throw new AssertionError((Object)"Updates Flasher cannot be null.");
        }
        flasher.setToolTipText(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Problem"));
        flasher.startFlashing();
    }

    private void notifyError(final int errorType) {
        Runnable onMouseClick = new Runnable(){

            public void run() {
                ConnectingErrorDialog.showDialog(errorType, null, true);
            }
        };
        ProblemsVisualizerProvider.UpdatesFlasher flasher = ProblemsVisualizerProvider.getFlasher(onMouseClick);
        if (!$assertionsDisabled && flasher == null) {
            throw new AssertionError((Object)"Updates Flasher cannot be null.");
        }
        flasher.setToolTipText(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_Problem"));
        flasher.startFlashing();
    }

    private void noUpdatesFound() {
        AutoCheckInfo info = new AutoCheckInfo(NbBundle.getMessage((Class)AutoChecker.class, (String)"MSG_AutoCheck_NotFound"), 1);
        info.showDialog(false);
    }

    private Collection getAllModules() {
        HashSet ret = new HashSet();
        Iterator it = this.allUpdates.values().iterator();
        while (it.hasNext()) {
            Collection c = ((Updates)it.next()).getModules();
            if (c == null) continue;
            ret.addAll(c);
        }
        return ret;
    }

    public void setValid(boolean valid) {
    }

    private boolean timeToCheck() {
        if (this.getReqularlyTimerTask() != null && this.getReqularlyTimerTask().getDelay() <= 0 && this.getWaitPeriod() > 0) {
            this.getReqularlyTimerTask().schedule(this.getWaitPeriod());
            return true;
        }
        if (this.settings.getLastCheck() == null) {
            return true;
        }
        switch (this.settings.getPeriod()) {
            case 0: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        Date lastCheck = this.settings.getLastCheck();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(lastCheck);
        calendar.set(10, 0);
        calendar.set(9, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (this.settings.getPeriod()) {
            case 1: {
                calendar.add(5, 1);
                break;
            }
            case 2: {
                calendar.add(3, 1);
                break;
            }
            case 3: {
                calendar.add(3, 2);
                break;
            }
            case 4: {
                calendar.add(2, 1);
            }
        }
        return calendar.getTime().before(new Date());
    }

    private RequestProcessor.Task getReqularlyTimerTask() {
        if (this.regularlyCheck == null && this.getWaitPeriod() > 0) {
            int waitPeriod;
            int restTime = waitPeriod = this.getWaitPeriod();
            if (this.settings.getLastCheck() != null) {
                restTime = waitPeriod - (int)(System.currentTimeMillis() - this.settings.getLastCheck().getTime());
            }
            if (restTime <= 0) {
                restTime = waitPeriod;
            }
            this.regularlyCheck = REGULARLY_CHECK_TIMER.post((Runnable)this, restTime, 1);
        }
        return this.regularlyCheck;
    }

    private int getWaitPeriod() {
        switch (this.settings.getPeriod()) {
            case 5: {
                return 0;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 86400000;
            }
            case 2: {
                return 604800000;
            }
            case 3: {
                return 1209600000;
            }
            case 4: {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    static {
        $assertionsDisabled = !AutoChecker.class.desiredAssertionStatus();
        REGULARLY_CHECK_TIMER = new RequestProcessor("auto-checker-reqularly-timer", 1, true);
    }
}

