/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.autoupdate.Autoupdater;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.openide.ErrorManager;
import org.openide.modules.SpecificationVersion;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PreparedModules {
    private static final String ELEMENT_MODULES = "module_updates";
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAMEBASE = "codenamebase";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SPEC_VERSION = "specification_version";
    private static final String ATTR_SIZE = "size";
    private static final String ATTR_NBM_NAME = "nbm_name";
    private List modules = new ArrayList();
    private boolean pError = false;
    private static PreparedModules preparedModules;
    static final /* synthetic */ boolean $assertionsDisabled;

    PreparedModules() {
    }

    static PreparedModules getPrepared() {
        if (preparedModules == null) {
            PreparedModules.readPrepared();
        }
        return preparedModules;
    }

    static void readPrepared() {
        preparedModules = new PreparedModules();
        preparedModules.read();
    }

    List getModules() {
        return this.modules;
    }

    void addModule(ModuleUpdate mu) {
        Module mod = new Module();
        mod.setCodenamebase(mu.getCodeNameBase());
        mod.setName(mu.getName());
        mod.setSize(mu.getDownloadSize());
        SpecificationVersion sv = mu.getRemoteModule().getSpecificationVersion();
        mod.setSpec_version(sv == null ? null : sv.toString());
        mod.setNbm_name(mu.getDistributionFilename());
        if (mu.isToInstallDir()) {
            mod.setCluster(mu.findInstallDirectory());
        } else {
            mod.setCluster(new File(System.getProperty("netbeans.user")));
        }
        this.modules.add(mod);
    }

    void removeModule(String codenamebase) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module mod = (Module)this.modules.get(i);
            if (!mod.getCodenamebase().equals(codenamebase)) continue;
            this.modules.remove(i);
            return;
        }
    }

    String getPreparedVersion(String codenamebase) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module mod = (Module)this.modules.get(i);
            if (!mod.getCodenamebase().equals(codenamebase)) continue;
            return mod.getSpec_version();
        }
        return null;
    }

    boolean hasNBM(String nbm_name) {
        for (int i = 0; i < this.modules.size(); ++i) {
            Module mod = (Module)this.modules.get(i);
            if (!mod.getNbm_name().equals(nbm_name)) continue;
            return true;
        }
        return false;
    }

    void delete() {
        List clusters = UpdateTracking.clusters(true);
        if (!$assertionsDisabled && clusters == null) {
            throw new AssertionError();
        }
        Iterator it = clusters.iterator();
        while (it.hasNext()) {
            this.getInstall_Later((File)it.next()).delete();
        }
    }

    private File getInstall_Later(File rootOfCluster) {
        return Autoupdater.Support.getInstall_Later(rootOfCluster);
    }

    void write() {
        List clusters = UpdateTracking.clusters(true);
        if (!$assertionsDisabled && clusters == null) {
            throw new AssertionError((Object)"Clusters cannot be empty.");
        }
        Iterator iter = clusters.iterator();
        while (iter.hasNext()) {
            this.writeToCluster((File)iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCluster(File cluster) {
        Document document = XMLUtil.createDocument((String)ELEMENT_MODULES, null, null, null);
        Element root = document.getDocumentElement();
        Element module = null;
        Iterator it = this.modules.iterator();
        boolean empty = true;
        while (it.hasNext()) {
            Module mod = (Module)it.next();
            if (!cluster.equals(mod.getCluster())) continue;
            module = document.createElement(ELEMENT_MODULE);
            module.setAttribute(ATTR_CODENAMEBASE, mod.getCodenamebase());
            module.setAttribute(ATTR_NAME, mod.getName());
            module.setAttribute(ATTR_SPEC_VERSION, mod.getSpec_version());
            module.setAttribute(ATTR_SIZE, Long.toString(mod.getSize()));
            module.setAttribute(ATTR_NBM_NAME, mod.getNbm_name());
            root.appendChild(module);
            empty = false;
        }
        if (empty) {
            return;
        }
        document.getDocumentElement().normalize();
        File installLaterFile = Autoupdater.Support.getInstall_Later(cluster);
        installLaterFile.getParentFile().mkdirs();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(installLaterFile);
            XMLUtil.write((Document)document, (OutputStream)os, (String)"UTF-8");
        }
        catch (FileNotFoundException fnfe) {
            ErrorManager.getDefault().notify((Throwable)fnfe);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                }
            }
        }
    }

    private void read() {
        this.modules.clear();
        Document document = null;
        try {
            List clusters = UpdateTracking.clusters(true);
            if (!$assertionsDisabled && clusters == null) {
                throw new AssertionError((Object)"Clusters cannot be empty.");
            }
            Iterator iter = clusters.iterator();
            while (iter.hasNext()) {
                File cluster = (File)iter.next();
                File installLaterFile = Autoupdater.Support.getInstall_Later(cluster);
                if (!installLaterFile.exists()) continue;
                FileInputStream is = new FileInputStream(installLaterFile);
                InputSource xmlInputSource = new InputSource(is);
                document = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), null);
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (!$assertionsDisabled && document == null) {
                    throw new AssertionError();
                }
                Element element = document.getDocumentElement();
                if (element == null || !element.getTagName().equals(ELEMENT_MODULES)) continue;
                this.scanElement_module_updates(element, cluster);
            }
        }
        catch (SAXException e) {
            System.out.println("Bad install_later");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.out.println("Missing install_later");
            e.printStackTrace();
            return;
        }
    }

    private void scanElement_module_updates(Element element, File cluster) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_MODULE)) continue;
            this.scanElement_module(nodeElement, cluster);
        }
    }

    private void scanElement_module(Element element, File cluster) {
        Module module = new Module();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_CODENAMEBASE)) {
                module.setCodenamebase(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SPEC_VERSION)) {
                module.setSpec_version(attr.getValue());
            }
            if (attr.getName().equals(ATTR_NAME)) {
                module.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_SIZE)) {
                try {
                    module.setSize(Long.parseLong(attr.getValue()));
                }
                catch (NumberFormatException nfe) {
                    module.setSize(0L);
                }
            }
            if (attr.getName().equals(ATTR_NBM_NAME)) {
                module.setNbm_name(attr.getValue());
            }
            module.setCluster(cluster);
        }
        this.modules.add(module);
    }

    static {
        $assertionsDisabled = !PreparedModules.class.desiredAssertionStatus();
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String level, SAXParseException e) {
            PreparedModules.this.pError = true;
        }

        public void error(SAXParseException e) {
            PreparedModules.this.pError = true;
        }

        public void warning(SAXParseException e) {
        }

        public void fatalError(SAXParseException e) {
            PreparedModules.this.pError = true;
        }
    }

    class Module {
        private String name;
        private String codenamebase;
        private String spec_version;
        private long size;
        private String nbm_name;
        private File cluster;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCodenamebase() {
            return this.codenamebase;
        }

        public void setCodenamebase(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        public String getSpec_version() {
            return this.spec_version;
        }

        public void setSpec_version(String spec_version) {
            this.spec_version = spec_version;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public String getNbm_name() {
            return this.nbm_name;
        }

        public void setNbm_name(String nbm_name) {
            this.nbm_name = nbm_name;
        }

        public void setCluster(File cluster) {
            this.cluster = cluster;
        }

        public File getCluster() {
            return this.cluster;
        }
    }
}

