/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.palette.HTMLPaletteUtilities;
import org.netbeans.modules.html.palette.items.TEXTAREACustomizer;
import org.openide.text.ActiveEditorDrop;

public class TEXTAREA
implements ActiveEditorDrop {
    public static final String STATE_DISABLED = "disabled";
    public static final String STATE_READONLY = "readonly";
    public static final int ROWS_DEFAULT = 4;
    public static final int COLS_DEFAULT = 20;
    private String name = "";
    private String value = "";
    private boolean disabled = false;
    private boolean readonly = false;
    private int rows = 4;
    private int cols = 20;

    public boolean handleTransfer(JTextComponent targetComponent) {
        TEXTAREACustomizer c = new TEXTAREACustomizer(this);
        boolean accept = c.showDialog();
        if (accept) {
            String body = this.createBody();
            try {
                HTMLPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody() {
        String strName = " name=\"" + this.name + "\"";
        String strValue = this.value;
        if (this.value.length() > 0) {
            strValue = strValue + "\n";
        }
        String strReadOnly = this.readonly ? " readonly=\"readonly\"" : "";
        String strDisabled = this.disabled ? " disabled=\"disabled\"" : "";
        String strRows = " rows=\"" + this.rows + "\"";
        String strCols = " cols=\"" + this.cols + "\"";
        String taBody = "<textarea" + strName + strRows + strCols + strReadOnly + strDisabled + ">\n" + strValue + "</textarea>";
        return taBody;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

