/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.project.SourceRoots;
import org.netbeans.modules.web.project.classpath.BootClassPathImplementation;
import org.netbeans.modules.web.project.classpath.JspSourcePathImplementation;
import org.netbeans.modules.web.project.classpath.ProjectClassPathImplementation;
import org.netbeans.modules.web.project.classpath.SourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final ClassPath[] cache = new ClassPath[10];
    private final Map dirCache = new HashMap();

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    private synchronized FileObject getDir(String propname) {
        String prop;
        FileObject fo = (FileObject)this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (prop = this.evaluator.getProperty(propname)) == null)) {
            fo = this.helper.resolveFileObject(prop);
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getDistJar() {
        return this.getDir("dist.war");
    }

    private FileObject getBuildTestClassesDir() {
        return this.getDir("build.test.classes.dir");
    }

    private FileObject getDocumentBaseDir() {
        return this.getDir("web.docbase.dir");
    }

    private int getType(FileObject file) {
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (int i = 0; i < srcPath.length; ++i) {
            FileObject root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 0;
        }
        FileObject dir = this.getDocumentBaseDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 5;
        }
        dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 2;
        }
        dir = this.getDistJar();
        if (dir != null && dir.equals(FileUtil.getArchiveFile((FileObject)file))) {
            return 4;
        }
        srcPath = this.getTestSrcDir();
        for (int i = 0; i < srcPath.length; ++i) {
            FileObject root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return 1;
        }
        dir = this.getBuildTestClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return 3;
        }
        return -1;
    }

    private ClassPath getCompileTimeClasspath(FileObject file) {
        int type = this.getType(file);
        return this.getCompileTimeClasspath(type);
    }

    private ClassPath getCompileTimeClasspath(int type) {
        ClassPath cp;
        if ((type < 0 || type > 2) && type != 5) {
            return null;
        }
        if (type == 2 || type == 5) {
            type = 0;
        }
        if ((cp = this.cache[3 + type]) == null) {
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "${javac.classpath}:${j2ee.platform.classpath}", this.evaluator, false)) : ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "${javac.test.classpath}:${j2ee.platform.classpath}", this.evaluator, false));
            this.cache[3 + type] = cp;
        }
        return cp;
    }

    private ClassPath getRunTimeClasspath(FileObject file) {
        int type = this.getType(file);
        if (type < 0 || type > 5) {
            return null;
        }
        switch (type) {
            case 2: 
            case 3: 
            case 4: {
                type -= 2;
                break;
            }
            case 5: {
                type = 0;
            }
        }
        ClassPath cp = this.cache[6 + type];
        if (cp == null) {
            if (type == 0) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "debug.classpath", this.evaluator));
            }
            this.cache[6 + type] = cp;
        }
        return cp;
    }

    private ClassPath getSourcepath(FileObject file) {
        int type = this.getType(file);
        return this.getSourcepath(type);
    }

    private ClassPath getSourcepath(int type) {
        if ((type < 0 || type > 2) && type != 5) {
            return null;
        }
        ClassPath cp = this.cache[type];
        if (cp == null) {
            switch (type) {
                case 0: 
                case 2: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper));
                    break;
                }
                case 1: {
                    cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.testSourceRoots, this.helper));
                    break;
                }
                case 5: {
                    cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)new JspSourcePathImplementation(this.helper, this.evaluator)), ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper))});
                }
            }
            this.cache[type] = cp;
        }
        return cp;
    }

    private ClassPath getBootClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            this.cache[7] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.evaluator));
        }
        return cp;
    }

    public ClassPath getJ2eePlatformClassPath() {
        ClassPath cp = this.cache[9];
        if (cp == null) {
            this.cache[9] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, "${j2ee.platform.classpath}", this.evaluator, false));
        }
        return cp;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(file);
        }
        if (type.equals("classpath/execute")) {
            return this.getRunTimeClasspath(file);
        }
        if (type.equals("classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/compile".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getCompileTimeClasspath(0), this.getCompileTimeClasspath(1)};
            return l;
        }
        if ("classpath/source".equals(type)) {
            ClassPath[] l = new ClassPath[]{this.getSourcepath(0), this.getSourcepath(5), this.getSourcepath(1)};
            return l;
        }
        assert (false);
        return null;
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        assert (false);
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }
}

