/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.data;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.DynamicProperties;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.PropertyList;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.data.Validator;

public class PropertyListMapping
implements Comparable {
    public static final String WEBAPP_JSPCONFIG_PROPERTIES = "WebAppJspConfigProperties";
    public static final String WEBAPP_PROPERTIES = "WebAppProperties";
    public static final String WEBAPP_CLASSLOADER_PROPERTIES = "WebAppClassloaderProperties";
    public static final String CACHE_PROPERTIES = "CacheProperties";
    public static final String CACHE_DEFAULT_HELPER_PROPERTIES = "CacheDefaultHelperProperties";
    public static final String CACHE_HELPER_PROPERTIES = "CacheHelperProperties";
    public static final String CONFIG_MANAGER_PROPERTIES = "ConfigManagerProperties";
    public static final String CONFIG_STORE_PROPERTIES = "ConfigStoreProperties";
    public static final String CONFIG_SESSION_PROPERTIES = "ConfigSessionProperties";
    public static final String CONFIG_COOKIE_PROPERTIES = "ConfigCookieProperties";
    public static final String SERVICE_REF_CALL_PROPERTIES = "ServiceRefCallProperties";
    public static final String SERVICE_REF_STUB_PROPERTIES = "ServiceRefStubProperties";
    public static final String EJBJAR_CMP_PROPERTIES = "EjbJarCmpProperties";
    public static final String EJBJAR_CMP_SCHEMA_PROPERTIES = "EjbJarCmpSchemaProperties";
    private final PropertyList propList;
    private static final String PROPERTYDATA_FILENAME = "org/netbeans/modules/j2ee/sun/share/configbean/customizers/data/propertydata.xml";
    private static Map propertyLists;
    private static Map validatorList;

    private PropertyListMapping(PropertyList l) {
        this.propList = l;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof PropertyListMapping) {
            if (this == obj) {
                result = true;
            } else {
                PropertyListMapping targetMapping = (PropertyListMapping)obj;
                PropertyList targetList = targetMapping.getPropertyList();
                result = this.propList.getPropertyName().equals(targetList.getPropertyName());
            }
        }
        return result;
    }

    public int hashCode() {
        return this.propList.getPropertyName().hashCode();
    }

    public String toString() {
        return this.propList.getPropertyName();
    }

    public PropertyList getPropertyList() {
        return this.propList;
    }

    public int compareTo(Object obj) {
        int result = -1;
        if (obj instanceof PropertyListMapping) {
            if (this == obj) {
                result = 0;
            } else {
                PropertyListMapping targetMapping = (PropertyListMapping)obj;
                PropertyList targetList = targetMapping.getPropertyList();
                result = this.propList.getPropertyName().compareTo(targetList.getPropertyName());
            }
        }
        return result;
    }

    public static PropertyList getPropertyList(String propertyListName) {
        return (PropertyList)propertyLists.get(propertyListName);
    }

    public static Pattern getValidator(String validatorName) {
        return (Pattern)validatorList.get(validatorName);
    }

    private static void loadPropertyLists() {
        propertyLists = new HashMap(37);
        validatorList = new HashMap(19);
        try {
            URL propertyListURL = Utils.getResourceURL(PROPERTYDATA_FILENAME, PropertyListMapping.class);
            InputStream inputStream = propertyListURL.openStream();
            DynamicProperties props = DynamicProperties.read(inputStream);
            Iterator iter = props.fetchPropertyListList().iterator();
            while (iter.hasNext()) {
                PropertyList propList = (PropertyList)iter.next();
                String propertyListName = propList.getPropertyName();
                propertyLists.put(propertyListName, propList);
            }
            iter = props.fetchValidatorList().iterator();
            while (iter.hasNext()) {
                Validator validator = (Validator)iter.next();
                Pattern pattern = Pattern.compile(validator.getValidatorPattern());
                validatorList.put(validator.getValidatorName(), pattern);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        PropertyListMapping.loadPropertyLists();
    }
}

