/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class MimeLookupUtils {
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.mimelookup.utils.sort.debug");
    private static List hidden = new ArrayList();

    private MimeLookupUtils() {
    }

    public static List mergeObjects(List dataFoldersList) {
        DataFolder folder;
        int i;
        HashMap name2dob = new HashMap();
        HashMap edges = new HashMap();
        hidden.clear();
        for (i = 0; i < dataFoldersList.size(); ++i) {
            folder = (DataFolder)dataFoldersList.get(i);
            MimeLookupUtils.addDataObjects(name2dob, folder.getChildren());
        }
        for (i = 0; i < dataFoldersList.size(); ++i) {
            folder = (DataFolder)dataFoldersList.get(i);
            MimeLookupUtils.addEdges(edges, name2dob, folder);
        }
        try {
            return Utilities.topologicalSort(name2dob.values(), edges);
        }
        catch (TopologicalSortException ex) {
            List corrected = ex.partialSort();
            ErrorManager em = ErrorManager.getDefault();
            em.log(16, "Note: MimeLookup objects cannot be consistently sorted due to ordering conflicts.");
            em.notify(1, (Throwable)ex);
            em.log(16, "Using partial sort: " + corrected);
            return corrected;
        }
    }

    private static void addDataObjects(Map name2dob, DataObject[] addDobs) {
        int addDobsLength = addDobs.length;
        for (int i = 0; i < addDobsLength; ++i) {
            DataObject dob = addDobs[i];
            String dobName = dob.getPrimaryFile().getNameExt();
            if (dobName != null && dobName.endsWith("_hidden")) {
                String originalName = dobName.substring(0, dobName.indexOf("_hidden"));
                hidden.add(originalName);
                continue;
            }
            if (MimeLookupUtils.isHidden(dob.getPrimaryFile())) {
                hidden.add(dobName);
                continue;
            }
            if (hidden.contains(dobName)) continue;
            if (dob instanceof DataFolder) {
                name2dob.put(dob.getPrimaryFile().getPath(), dob);
                continue;
            }
            name2dob.put(dobName, dob);
        }
    }

    private static boolean isHidden(FileObject fo) {
        Enumeration e = fo.getAttributes();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (!"hidden".equals(name) || !((value = fo.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void addEdges(Map edges, Map name2dob, DataFolder folder) {
        FileObject primaryFile = folder.getPrimaryFile();
        String path = primaryFile.getPath();
        Enumeration e = primaryFile.getAttributes();
        while (e.hasMoreElements()) {
            DataObject target;
            DataObject dob;
            Object value;
            String name = (String)e.nextElement();
            int slashIndex = name.indexOf("/");
            if (slashIndex == -1 || !((value = primaryFile.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            String name1 = name.substring(0, slashIndex);
            String name2 = name.substring(slashIndex + 1);
            if (debugSort) {
                System.err.println("SORT-PAIR: [" + name1 + ", " + name2 + "]");
            }
            if ((dob = (DataObject)name2dob.get(name1)) == null) {
                String pathName = path + "/" + name1;
                dob = (DataObject)name2dob.get(pathName);
            }
            if ((target = (DataObject)name2dob.get(name2)) == null) {
                String pathName = path + "/" + name1;
                target = (DataObject)name2dob.get(pathName);
            }
            if (dob == null || target == null) continue;
            Collection<DataObject> targetVertices = (List<DataObject>)edges.get(dob);
            if (targetVertices == null) {
                targetVertices = Collections.singletonList(target);
                edges.put(dob, targetVertices);
                continue;
            }
            if (targetVertices.size() == 1) {
                targetVertices = new HashSet<DataObject>(targetVertices);
                targetVertices.add(target);
                edges.put(dob, targetVertices);
                continue;
            }
            targetVertices.add(target);
        }
    }
}

