/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.api;

import java.util.Iterator;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistenceapi.PersistenceScopeAccessor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class PersistenceScope {
    private static final Lookup.Result providers = Lookup.getDefault().lookup(new Lookup.Template(PersistenceScopeProvider.class));
    private final PersistenceScopeImplementation impl;

    public static PersistenceScope getPersistenceScope(FileObject fo) {
        if (fo == null) {
            throw new NullPointerException("Passed null to PersistenceScope.getPersistenceScope(FileObject)");
        }
        Iterator it = providers.allInstances().iterator();
        while (it.hasNext()) {
            PersistenceScopeProvider provider = (PersistenceScopeProvider)it.next();
            PersistenceScope persistenceScope = provider.findPersistenceScope(fo);
            if (persistenceScope == null) continue;
            return persistenceScope;
        }
        return null;
    }

    private PersistenceScope(PersistenceScopeImplementation impl) {
        this.impl = impl;
    }

    public FileObject getPersistenceXml() {
        return this.impl.getPersistenceXml();
    }

    public ClassPath getClassPath() {
        return this.impl.getClassPath();
    }

    static {
        PersistenceScopeAccessor.DEFAULT = new PersistenceScopeAccessor(){

            public PersistenceScope createPersistenceScope(PersistenceScopeImplementation impl) {
                return new PersistenceScope(impl);
            }
        };
    }
}

