/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.html.HTMLSyntax;

public class LineWrapFormatter
extends ExtFormatter {
    int textLimit;
    Class kitClass;

    public LineWrapFormatter(Class kitClass) {
        super(kitClass);
        this.kitClass = kitClass;
        this.textLimit = this.getTextLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTextLimit() {
        Object localValue = this.getSettingValue("text-limit-width");
        if (localValue != null && localValue instanceof Integer) {
            return (Integer)localValue;
        }
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Object settingsValue = Settings.getValue((Class)this.kitClass, (String)"text-limit-width");
            if (settingsValue != null && settingsValue instanceof Integer) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return (Integer)settingsValue;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return SettingsDefaults.defaultTextLimitWidth;
        }
    }

    public void settingsChange(SettingsChangeEvent evt) {
        String name;
        super.settingsChange(evt);
        String string = name = evt != null ? evt.getSettingName() : null;
        if (name == null || "text-limit-width".equals(name)) {
            this.textLimit = this.getTextLimit();
        }
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof HTMLSyntax;
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        int dotPos = target.getCaret().getDot();
        if (typedText.length() == 0 || typedText.charAt(0) == '\b' || typedText.charAt(0) == '\u007f') {
            return null;
        }
        if (doc != null) {
            try {
                String preText;
                int lastSpace;
                int rstart = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
                if (dotPos - rstart > this.textLimit && (lastSpace = (preText = doc.getText(rstart, dotPos - rstart)).lastIndexOf(32)) > 0) {
                    doc.remove(rstart + lastSpace, 1);
                    doc.insertString(rstart + lastSpace, "\n", null);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected int getEOLOffset(BaseDocument bdoc, int offset) throws BadLocationException {
        return offset;
    }

    protected void initFormatLayers() {
    }
}

