/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.BasicAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataClass;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLClassAccessor;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import org.w3c.dom.Node;

public class EmbeddedAccessor
extends BasicAccessor {
    protected boolean m_isEmbeddedId;

    public EmbeddedAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor, boolean isEmbeddedId) {
        super(accessibleObject, classAccessor);
        this.m_isEmbeddedId = isEmbeddedId;
    }

    public boolean isEmbedded() {
        return true;
    }

    public boolean isEmbeddedId() {
        return this.m_isEmbeddedId;
    }

    public void process() {
        if (this.isEmbeddedId()) {
            this.processEmbeddedId();
        }
        MetadataDescriptor referenceDescriptor = this.processEmbeddableClass();
        this.m_descriptor.addAggregateDescriptor(referenceDescriptor);
        if (this.m_descriptor.hasMappingForAttributeName(this.getAttributeName())) {
            this.m_logger.logWarningMessage(MetadataLogger.IGNORE_MAPPING, this.m_descriptor, this);
        } else {
            AggregateObjectMapping mapping = new AggregateObjectMapping();
            mapping.setIsReadOnly(false);
            mapping.setIsNullAllowed(true);
            mapping.setReferenceClassName(this.getReferenceClassName());
            mapping.setAttributeName(this.getAttributeName());
            this.setAccessorMethods(mapping);
            this.processAttributeOverrides(mapping);
            this.processAssociationOverrides(mapping);
            this.m_descriptor.addMapping(mapping);
        }
    }

    protected void processAssociationOverride(AssociationOverride associationOverride, AggregateObjectMapping aggregateMapping) {
        String name;
        MetadataDescriptor aggregateDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = aggregateDescriptor.getMappingForAttributeName(name = associationOverride.name());
        if (mapping == null) {
            // empty if block
        }
        if (mapping.isOneToOneMapping()) {
            int index = 0;
            for (JoinColumn joinColumn : associationOverride.joinColumns()) {
                DatabaseField fkField = (DatabaseField)((OneToOneMapping)mapping).getForeignKeyFields().elementAt(index++);
                aggregateMapping.addFieldNameTranslation(joinColumn.name(), fkField.getName());
            }
        }
    }

    protected void processAssociationOverrides(AggregateObjectMapping mapping) {
        AssociationOverride associationOverride;
        AssociationOverrides associationOverrides = (AssociationOverrides)this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (AssociationOverride associationOverride2 : associationOverrides.value()) {
                this.processAssociationOverride(associationOverride2, mapping);
            }
        }
        if ((associationOverride = (AssociationOverride)this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(associationOverride, mapping);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, MetadataColumn column) {
        String attributeName = column.getAttributeName();
        DatabaseMapping aggregateMapping = this.getReferenceDescriptor().getMappingForAttributeName(attributeName);
        if (aggregateMapping == null) {
            this.m_validator.throwInvalidEmbeddableAttribute(this.getJavaClass(), mapping.getAttributeName(), this.getReferenceDescriptor().getJavaClass(), attributeName);
        }
        DatabaseField field = this.m_descriptor.hasAttributeOverrideFor(attributeName) ? this.m_descriptor.getAttributeOverrideFor(attributeName).getDatabaseField() : column.getDatabaseField();
        mapping.addFieldNameTranslation(field.getQualifiedName(), aggregateMapping.getField().getName());
    }

    protected void processAttributeOverrides(AggregateObjectMapping mapping) {
        AttributeOverride attributeOverride;
        AttributeOverrides attributeOverrides = (AttributeOverrides)this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrides.value()) {
                this.processAttributeOverride(mapping, new MetadataColumn(attributeOverride2.column(), attributeOverride2.name(), this.getAnnotatedElement()));
            }
        }
        if ((attributeOverride = (AttributeOverride)this.getAnnotation(AttributeOverride.class)) != null) {
            this.processAttributeOverride(mapping, new MetadataColumn(attributeOverride.column(), attributeOverride.name(), this.getAnnotatedElement()));
        }
    }

    protected MetadataDescriptor processEmbeddableClass() {
        boolean entityUsesPropertyAccess;
        boolean embeddableUsesPropertyAccess;
        Class embeddableClass = this.getReferenceClass();
        MetadataDescriptor embeddableDescriptor = null;
        try {
            embeddableDescriptor = this.m_project.getDescriptor(embeddableClass);
        }
        catch (ValidationException ve) {
            // empty catch block
        }
        if (embeddableDescriptor == null) {
            embeddableDescriptor = new MetadataDescriptor(embeddableClass);
            this.m_project.addDescriptor(embeddableDescriptor);
            embeddableDescriptor.setIgnoreAnnotations(this.isMetadataComplete(embeddableDescriptor));
            AccessType accessType = this.determineAccessTypeOfEmbedded(embeddableDescriptor);
            embeddableDescriptor.setUsesPropertyAccess(accessType == AccessType.PROPERTY);
            ClassAccessor embeddableAccessor = this.makeAccessorFor(embeddableDescriptor);
            embeddableAccessor.process();
            embeddableAccessor.setIsProcessed();
        } else if (!this.isMetadataPresent(embeddableDescriptor) && (embeddableUsesPropertyAccess = embeddableDescriptor.usesPropertyAccess()) != (entityUsesPropertyAccess = this.m_descriptor.usesPropertyAccess())) {
            this.m_validator.throwConflictingAccessTypeInEmbeddable(embeddableClass);
        }
        if (this.isEmbeddedId() && !this.m_descriptor.ignoreIDs()) {
            for (DatabaseMapping mapping : embeddableDescriptor.getMappings()) {
                DatabaseField field = (DatabaseField)mapping.getField().clone();
                field.setTableName(this.m_descriptor.getPrimaryTableName());
                this.m_descriptor.addPrimaryKeyField(field);
            }
        }
        return embeddableDescriptor;
    }

    private boolean isMetadataComplete(MetadataDescriptor emDesc) {
        boolean metadataComplete;
        Class emClass = emDesc.getJavaClass();
        boolean bl = metadataComplete = this.m_project.getPersistenceUnit() != null ? this.m_project.getPersistenceUnit().isMetadataComplete() : false;
        if (!metadataComplete && this.m_project.hasEmbeddable(emClass)) {
            XMLHelper helper = this.m_project.getEmbeddableHelper(emClass);
            Node node = this.m_project.getEmbeddableNode(emClass);
            metadataComplete = helper.getNodeValue(node, "@metadata-complete", false);
        }
        return metadataComplete;
    }

    private boolean isMetadataPresent(MetadataDescriptor desc) {
        AccessType annotAccessType = this.computeAccessTypeFromAnnotation(desc);
        AccessType xmlAccessType = this.computeAccessTypeFromXML(desc);
        return annotAccessType != AccessType.UNDEFINED || xmlAccessType != AccessType.UNDEFINED;
    }

    private AccessType computeAccessTypeFromAnnotation(MetadataDescriptor desc) {
        Class javaClass = desc.getJavaClass();
        boolean fieldAccess = MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getFields(javaClass));
        boolean propAccess = MetadataHelper.havePersistenceAnnotationsDefined(MetadataHelper.getMethods(javaClass));
        AccessType accessType = AccessType.UNDEFINED;
        if (fieldAccess && propAccess) {
            accessType = AccessType.MIXED;
        } else if (fieldAccess) {
            accessType = AccessType.FIELD;
        } else if (propAccess) {
            accessType = AccessType.PROPERTY;
        }
        return accessType;
    }

    private AccessType computeAccessTypeFromXML(MetadataDescriptor desc) {
        String access = this.m_project.getPersistenceUnit() != null ? this.m_project.getPersistenceUnit().getAccess() : null;
        Class javaClass = desc.getJavaClass();
        if (this.m_project.hasEmbeddable(javaClass)) {
            XMLHelper helper = this.m_project.getEmbeddableHelper(javaClass);
            Node node = this.m_project.getEmbeddableNode(javaClass);
            access = helper.getNodeValue(node, "@access", access);
        }
        AccessType accessType = AccessType.UNDEFINED;
        if (access != null && access.length() != 0) {
            accessType = AccessType.valueOf(access);
        }
        return accessType;
    }

    private AccessType determineAccessTypeOfEmbedded(MetadataDescriptor emDesc) {
        AccessType entityAccessType = this.m_descriptor.usesPropertyAccess() ? AccessType.PROPERTY : AccessType.FIELD;
        AccessType accessType = AccessType.UNDEFINED;
        boolean metadataComplete = emDesc.ignoreAnnotations();
        AccessType accessTypeUsingAnnotation = this.computeAccessTypeFromAnnotation(emDesc);
        AccessType accessTypeUsingXML = this.computeAccessTypeFromXML(emDesc);
        if (metadataComplete) {
            accessType = accessTypeUsingXML != AccessType.UNDEFINED ? accessTypeUsingXML : entityAccessType;
        } else if (accessTypeUsingAnnotation == AccessType.UNDEFINED && accessTypeUsingAnnotation == AccessType.UNDEFINED) {
            accessType = entityAccessType;
        } else if (accessTypeUsingXML == AccessType.UNDEFINED && accessTypeUsingAnnotation != AccessType.UNDEFINED) {
            accessType = accessTypeUsingAnnotation;
            if (accessType == AccessType.MIXED) {
                this.m_validator.throwBothFieldsAndPropertiesAnnotatedException(emDesc.getJavaClass());
            }
        } else if (accessTypeUsingAnnotation == AccessType.UNDEFINED && accessTypeUsingXML != AccessType.UNDEFINED) {
            accessType = accessTypeUsingXML;
        } else if (accessTypeUsingAnnotation == accessTypeUsingXML) {
            accessType = accessTypeUsingAnnotation;
        } else {
            this.m_validator.throwIncorrectOverridingOfAccessType(emDesc.getJavaClass(), accessTypeUsingXML.toString(), accessTypeUsingAnnotation.toString());
        }
        assert (accessType != AccessType.UNDEFINED && accessType != AccessType.MIXED);
        return accessType;
    }

    private ClassAccessor makeAccessorFor(MetadataDescriptor embeddableDescriptor) {
        ClassAccessor embeddableAccessor;
        Class embeddableClass = embeddableDescriptor.getJavaClass();
        if (this.m_project.hasEmbeddable(embeddableClass)) {
            Node node = this.m_project.getEmbeddableNode(embeddableClass);
            XMLHelper helper = this.m_project.getEmbeddableHelper(embeddableClass);
            embeddableAccessor = new XMLClassAccessor(new MetadataClass(embeddableClass), node, helper, this.m_processor, embeddableDescriptor);
        } else if (MetadataHelper.isAnnotationPresent(Embeddable.class, embeddableClass, embeddableDescriptor)) {
            embeddableAccessor = new ClassAccessor(new MetadataClass(embeddableClass), this.m_processor, embeddableDescriptor);
        } else {
            this.m_validator.throwInvalidEmbeddedAttribute(this.m_descriptor.getDescriptor().getJavaClass(), this.m_accessibleObject.getName(), embeddableClass);
            throw new RuntimeException("Will never reach here");
        }
        embeddableDescriptor.setClassAccessor(embeddableAccessor);
        return embeddableAccessor;
    }

    public void processEmbeddedId() {
        if (this.m_descriptor.ignoreIDs()) {
            this.m_logger.logWarningMessage(MetadataLogger.IGNORE_EMBEDDED_ID, this);
        } else {
            if (this.m_descriptor.hasEmbeddedIdAttribute()) {
                this.m_validator.throwMultipleEmbeddedIdsFound(this.getJavaClass(), this.getAttributeName(), this.m_descriptor.getEmbeddedIdAttributeName());
            }
            if (this.m_descriptor.hasPrimaryKeyFields()) {
                this.m_validator.throwEmbeddedIdAndIdFound(this.getJavaClass(), this.getAttributeName(), this.m_descriptor.getIdAttributeName());
            }
            this.m_descriptor.setPKClass(this.getReferenceClass());
            this.m_descriptor.setEmbeddedIdAttributeName(this.getAttributeName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AccessType {
        FIELD,
        PROPERTY,
        UNDEFINED,
        MIXED;

    }
}

