/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.autocomplete;

import com.sun.j2ee.blueprints.ui.autocomplete.AutoCompleteComponent;
import com.sun.j2ee.blueprints.ui.util.Util;
import java.beans.Beans;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class AutoCompleteRenderer
extends Renderer {
    private static final String CSS_RESOURCE = "/META-INF/autocomplete/styles.css";
    private static final String SCRIPT_RESOURCE = "/META-INF/autocomplete/script.js";
    private static final String COMPLETION_HANDLER = "/bpui_autocomplete_handler/completions";
    private static String[] booleanPassthruAttributes = new String[]{"disabled", "readonly", "ismap"};
    private static String[] integerPassthruAttributes = new String[]{"maxlength", "size"};
    private static String[] passthruAttributes = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "longdesc", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rows", "rules", "shape", "style", "summary", "tabindex", "target", "title", "usemap", "width"};
    private static XhtmlHelper helper = new XhtmlHelper();

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        AutoCompleteComponent auto = (AutoCompleteComponent)component;
        if (auto.isDisabled() || auto.isReadonly()) {
            return;
        }
        String clientId = auto.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        auto.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        AutoCompleteComponent auto = (AutoCompleteComponent)component;
        String clientId = auto.getClientId(context);
        String name = this.name(context, auto);
        ResponseWriter writer = context.getResponseWriter();
        if (!Beans.isDesignTime()) {
            helper.linkStylesheet(context, component, writer, Mechanism.CLASS_RESOURCE, CSS_RESOURCE);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, "/META-INF/common/script.js");
            Util.renderDojoLoading(context, component, writer);
            helper.linkJavascript(context, component, writer, Mechanism.CLASS_RESOURCE, SCRIPT_RESOURCE);
            writer.startElement("script", (UIComponent)auto);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\n");
            writer.write("bpui.autocomplete.messages[\"bindError\"] = \"" + Util.getMessage("autocomplete.bindError") + "\";");
            writer.write("\n");
            writer.endElement("script");
            writer.write("\n");
        }
        if (!Beans.isDesignTime()) {
            writer.startElement("div", (UIComponent)auto);
            writer.writeAttribute("id", (Object)(clientId + "_menu"), null);
            writer.writeAttribute("style", (Object)"position: absolute; top:170px;left:140px;visibility:hidden", null);
            writer.writeAttribute("class", (Object)"popupFrame", null);
            writer.endElement("div");
            writer.write("\n");
        }
        writer.startElement("input", (UIComponent)auto);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("name", (Object)clientId, "clientId");
        Object value = auto.getValue();
        if (value != null) {
            writer.writeAttribute("value", value, "value");
        }
        if ((styleClass = auto.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.writeAttribute("autocomplete", (Object)"off", null);
        this.renderBooleanPassThruAttributes(writer, component);
        this.renderIntegerPassThruAttributes(writer, component);
        this.renderStringPassThruAttributes(writer, component);
        if (auto.getCompletionMethod() != null) {
            String continueScript = name + ".again()";
            String startScript = name + ".start()";
            String stopScript = name + ".stop()";
            writer.writeAttribute("onfocus", (Object)startScript, null);
            writer.writeAttribute("onkeyup", (Object)continueScript, null);
            writer.writeAttribute("onblur", (Object)stopScript, null);
        }
        writer.endElement("input");
        writer.write("\n");
        if (!Beans.isDesignTime()) {
            String methodName = null;
            if (auto.getCompletionMethod() != null) {
                methodName = auto.getCompletionMethod().getExpressionString();
            }
            writer.startElement("script", (UIComponent)auto);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.write("\n");
            writer.write("var " + name + " = new bpui.autocomplete.Component(");
            writer.write("dojo.byId('" + clientId + "'), ");
            writer.write("dojo.byId('" + clientId + "_menu'), ");
            if (methodName != null) {
                writer.write("'" + methodName + "', ");
            } else {
                writer.write("null, ");
            }
            writer.write("'" + helper.mapResourceId(context, Mechanism.DYNAMIC_RESOURCE, COMPLETION_HANDLER) + "', ");
            if (auto.getOnchoose() != null) {
                writer.write(auto.getOnchoose() + ", ");
            } else {
                writer.write("null, ");
            }
            if (auto.getOndisplay() != null) {
                writer.write(auto.getOndisplay());
            } else {
                writer.write("null");
            }
            writer.write(");");
            writer.write("\n");
            writer.endElement("script");
            writer.write("\n");
        }
    }

    private String name(FacesContext context, AutoCompleteComponent auto) {
        return auto.getClientId(context).replace(':', '_');
    }

    private void renderBooleanPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        boolean result = false;
        for (int i = 0; i < booleanPassthruAttributes.length; ++i) {
            Object value = component.getAttributes().get(booleanPassthruAttributes[i]);
            if (value == null) continue;
            if (value instanceof Boolean) {
                result = (Boolean)value;
            } else if (value instanceof String) {
                result = new Boolean((String)value);
            }
            if (!result) continue;
            writer.writeAttribute(booleanPassthruAttributes[i], (Object)booleanPassthruAttributes[i], booleanPassthruAttributes[i]);
        }
    }

    private void renderIntegerPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        for (int i = 0; i < integerPassthruAttributes.length; ++i) {
            int intValue;
            Object value = component.getAttributes().get(integerPassthruAttributes[i]);
            if (value == null || !(value instanceof Integer) || (intValue = ((Integer)value).intValue()) == Integer.MIN_VALUE) continue;
            writer.writeAttribute(integerPassthruAttributes[i], (Object)value.toString(), integerPassthruAttributes[i]);
        }
    }

    private void renderStringPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        for (int i = 0; i < passthruAttributes.length; ++i) {
            Object value = component.getAttributes().get(passthruAttributes[i]);
            if (value == null) continue;
            if (!(value instanceof String)) {
                value = value.toString();
            }
            writer.writeAttribute(passthruAttributes[i], (Object)((String)value), passthruAttributes[i]);
        }
    }
}

