/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.maplocator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;

public class GeoCoder {
    private String applicationId = null;
    private static String SERVICE_URL = "http://api.local.yahoo.com/MapsService/V1/geocode";
    private static String APPLICATION_ID = "jsf-geo-map";

    public static String locate(String proxyHost, String proxyPort, String location) throws IOException {
        if (proxyHost != null && proxyHost != "" && proxyPort != null && proxyPort != "") {
            System.out.println("Contacting Geocoding service with proxy host:" + proxyHost + " proxy port:" + proxyPort);
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", proxyPort);
        }
        if (location == null) {
            System.err.println("Please provide a location to check");
            return null;
        }
        try {
            location = URLEncoder.encode(location, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException ee) {
            System.err.println("Unsupported Encoding");
            return null;
        }
        String urlString = SERVICE_URL + "?appid=" + APPLICATION_ID + "&location=" + location;
        StringBuffer sb = new StringBuffer();
        try {
            URL url = new URL(urlString);
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection) {
                String inputLine;
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                httpConnection.connect();
                int response = httpConnection.getResponseCode();
                if (response != 200) {
                    System.err.println("Problem contacting service.  Response Code:" + response);
                    return null;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                in.close();
            }
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
            throw new IOException("UnKnown Host: " + uhe.getMessage() + " -  Do you need to set a proxy?");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        return sb.toString();
    }
}

