/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j2ee.blueprints.ui.util;

import com.sun.j2ee.blueprints.ui.util.ConstantMethodBinding;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.XhtmlHelper;

public class Util {
    public static final String UI_MESSAGE_STRINGS = "com.sun.j2ee.blueprints.ui.MessageStrings";
    public static final String UTIL_LOGGER = "com.sun.j2ee.blueprints";
    public static final String UI_LOG_STRINGS = "com.sun.j2ee.blueprints.ui.LogStrings";
    public static final String UI_LOGGER = "com.sun.j2ee.blueprints.ui.";
    public static final String UI_COMMON_DOJO_RESOURCE = "/META-INF/dojo/dojo.js";
    public static final String UI_COMMON_SCRIPT_RESOURCE = "/META-INF/common/script.js";
    private static Logger logger = Util.getLogger("com.sun.j2ee.blueprints");
    private static XhtmlHelper helper = new XhtmlHelper();
    private static String[] booleanPassthruAttributes = new String[]{"disabled", "readonly", "ismap"};
    private static String[] passthruAttributes = new String[]{"accept", "accesskey", "alt", "bgcolor", "border", "cellpadding", "cellspacing", "charset", "cols", "coords", "dir", "enctype", "frame", "height", "hreflang", "lang", "xml", "longdesc", "maxlength", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload", "rel", "rev", "rows", "rules", "shape", "size", "style", "summary", "tabindex", "target", "title", "usemap", "width"};
    private static final String RENDERED_RESOURCE = "com.sun.j2ee.blueprints.RENDERED_RESOURCE";
    private static Map bundles = new HashMap();

    public static Logger getLogger(String loggerName) {
        return Logger.getLogger(loggerName, UI_LOG_STRINGS);
    }

    private Util() {
        throw new IllegalStateException();
    }

    public static String renderBooleanPassthruAttributes(FacesContext context, UIComponent component) {
        int i = 0;
        int len = booleanPassthruAttributes.length;
        boolean thisIsTheFirstAppend = true;
        StringBuffer renderedText = new StringBuffer();
        for (i = 0; i < len; ++i) {
            String value = (String)component.getAttributes().get(booleanPassthruAttributes[i]);
            if (null == value) continue;
            if (thisIsTheFirstAppend) {
                renderedText.append(' ');
                thisIsTheFirstAppend = false;
            }
            if (!Boolean.valueOf(value).booleanValue()) continue;
            renderedText.append(booleanPassthruAttributes[i] + ' ');
        }
        return renderedText.toString();
    }

    public static void renderDojoLoading(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("\n");
        writer.write("if (typeof dojo == 'undefined') {\n");
        writer.write("    bpui.load(\"" + helper.mapResourceId(context, Mechanism.CLASS_RESOURCE, UI_COMMON_DOJO_RESOURCE) + "\");\n");
        writer.write("}\n");
        writer.endElement("script");
        writer.write("\n");
    }

    public static String renderPassthruAttributes(FacesContext context, UIComponent component) {
        int i = 0;
        int len = passthruAttributes.length;
        boolean thisIsTheFirstAppend = true;
        StringBuffer renderedText = new StringBuffer();
        for (i = 0; i < len; ++i) {
            String value = (String)component.getAttributes().get(passthruAttributes[i]);
            if (null == value) continue;
            if (thisIsTheFirstAppend) {
                renderedText.append(' ');
                thisIsTheFirstAppend = false;
            }
            renderedText.append(passthruAttributes[i] + "=\"" + value + "\" ");
        }
        return renderedText.toString();
    }

    public static ValueBinding getValueExpression(String exprString, Class expectedType, FacesContext context) {
        ValueBinding ve = context.getApplication().createValueBinding(exprString);
        return ve;
    }

    public static void renderResourceOnce(FacesContext context, ResponseWriter writer, UIComponent component, String pathToResource, String contentType) throws IOException {
        String key = RENDERED_RESOURCE + pathToResource;
        if (!context.getExternalContext().getRequestMap().containsKey(key)) {
            context.getExternalContext().getRequestMap().put(key, Boolean.TRUE);
            if ("text/css".equals(contentType)) {
                writer.startElement("link", component);
                writer.writeAttribute("type", (Object)contentType, null);
                writer.writeAttribute("rel", (Object)"stylesheet", null);
                StringBuffer src = new StringBuffer();
                src.append(context.getExternalContext().getRequestContextPath());
                src.append("/faces/resource?r=");
                src.append(pathToResource);
                writer.writeAttribute("href", (Object)src.toString(), null);
                writer.endElement("link");
                writer.write("\n");
            } else {
                writer.startElement("script", component);
                writer.writeAttribute("type", (Object)contentType, null);
                StringBuffer src = new StringBuffer();
                src.append(context.getExternalContext().getRequestContextPath());
                src.append("/faces/resource?r=");
                src.append(pathToResource);
                writer.writeAttribute("src", (Object)src.toString(), null);
                writer.endElement("script");
                writer.write("\n");
            }
        }
    }

    public static MethodBinding createConstantMethodBinding(String outcome) {
        return new ConstantMethodBinding(outcome);
    }

    public static String getMessage(String key) {
        ResourceBundle bundle;
        Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = (ResourceBundle)bundles.get(locale)) == null) {
            ClassLoader cl = Util.class.getClassLoader();
            bundle = ResourceBundle.getBundle(UI_MESSAGE_STRINGS, locale, cl);
            bundles.put(locale, bundle);
        }
        return bundle.getString(key);
    }
}

